/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.datagen;

import com.peeko32213.seafarer.core.registry.SFItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "seafarer", existingFileHelper);
    }

    protected void registerModels() {
        for (Item i : BuiltInRegistries.f_257033_) {
            if (!(i instanceof SpawnEggItem) || !ForgeRegistries.ITEMS.getKey((Object)i).m_135827_().equals("seafarer")) continue;
            ((ItemModelBuilder)this.getBuilder(ForgeRegistries.ITEMS.getKey((Object)i).m_135815_())).parent((ModelFile)this.getExistingFile(new ResourceLocation("item/template_spawn_egg")));
        }
        this.singleTex(SFItems.RAW_SHORE_CRAB);
        this.singleTex(SFItems.COOKED_SHORE_CRAB);
        this.singleTex(SFItems.RAW_HORSESHOE_CRAB);
        this.singleTex(SFItems.COOKED_HORSESHOE_CRAB);
        this.singleTex(SFItems.MESSAGE_IN_A_BOTTLE);
        this.singleTex(SFItems.OLD_BOARD);
        this.singleTex(SFItems.OLD_BOOT);
        this.singleTex(SFItems.CAN);
        this.singleTex(SFItems.SOY_SAUCE);
        this.singleTex(SFItems.RAW_MARINE_IGUANA);
        this.singleTex(SFItems.COOKED_MARINE_IGUANA);
        this.singleTex(SFItems.SALT);
        this.singleTex(SFItems.SALTED_COD);
        this.singleTex(SFItems.SALTED_SALMON);
        this.singleTex(SFItems.SALTED_TROPICAL_FISH);
        this.singleTex(SFItems.SALTED_STARFISH);
        this.singleTex(SFItems.COOKED_STARFISH);
    }

    private void toBlock(RegistryObject<Block> b) {
        this.toBlockModel(b, b.getId().m_135815_());
    }

    private void toBlockModel(RegistryObject<Block> b, String model) {
        this.toBlockModel(b, ItemModelGenerator.prefix("block/" + model));
    }

    private void toBlockModel(RegistryObject<Block> b, ResourceLocation model) {
        this.withExistingParent(b.getId().m_135815_(), model);
    }

    private ItemModelBuilder singleTex(Item item) {
        return this.generated(ItemModelGenerator.key(item).m_135815_(), ItemModelGenerator.prefix("item/" + ItemModelGenerator.key(item).m_135815_()));
    }

    private ItemModelBuilder singleTex(RegistryObject<Item> item) {
        return this.generated(item.getId().m_135815_(), ItemModelGenerator.prefix("item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation("seafarer", name);
    }

    public static ResourceLocation key(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item);
    }
}

