/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.world;

import com.google.common.collect.ImmutableList;
import com.peeko32213.seafarer.datagen.ItemModelGenerator;
import com.peeko32213.seafarer.world.SConfiguredFeatures;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class SPlacedFeatures {
    public static List<String> placedFeatureList = new ArrayList<String>();
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registries.f_256988_, (String)"seafarer");
    public static final ResourceKey<PlacedFeature> BEACHGRASS_PLACED = SPlacedFeatures.registerKey("beachgrass_placed");
    public static final ResourceKey<PlacedFeature> BEACHGRASS_FAN_PLACED = SPlacedFeatures.registerKey("beachgrass_fan_placed");
    public static final ResourceKey<PlacedFeature> SEA_HOLLY_PLACED = SPlacedFeatures.registerKey("sea_holly_placed");
    public static final ResourceKey<PlacedFeature> SEA_THRIFT_PLACED = SPlacedFeatures.registerKey("sea_thrift_placed");
    public static final ResourceKey<PlacedFeature> COASTAL_LAVENDER_PLACED = SPlacedFeatures.registerKey("coastal_lavender_placed");
    public static final ResourceKey<PlacedFeature> COASTAL_WILDFLOWER_PLACED = SPlacedFeatures.registerKey("coastal_wildflower_placed");
    public static final ResourceKey<PlacedFeature> ALGAE_BOULDER_PLACED = SPlacedFeatures.registerKey("algae_boulder_placed");
    public static final ResourceKey<PlacedFeature> SEA_SHELL_LAND = SPlacedFeatures.registerKey("sea_shell_land");
    public static final ResourceKey<PlacedFeature> SEA_SHELL_WATER = SPlacedFeatures.registerKey("sea_shell_water");
    public static final ResourceKey<PlacedFeature> SEA_GLASS = SPlacedFeatures.registerKey("sea_glass");
    public static final ResourceKey<PlacedFeature> SEA_STAR_LAND = SPlacedFeatures.registerKey("sea_star_land");
    public static final ResourceKey<PlacedFeature> SEA_STAR_WATER = SPlacedFeatures.registerKey("sea_star_water");
    public static final ResourceKey<PlacedFeature> JUMBLED_SHELLY_SAND_PATCH = SPlacedFeatures.registerKey("jumbled_shelly_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> FLOATSOME = SPlacedFeatures.registerKey("floatsome");
    public static final ResourceKey<PlacedFeature> SCATTERED_SHELLY_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("scattered_shelly_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> MIXED_SHELLY_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("mixed_shelly_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> GRAVELY_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("gravely_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> ROCKY_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("rocky_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> RED_SPRINKLED_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("red_sprinkled_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> PURPLE_SPRINKLED_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("purple_sprinkled_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> PINK_SPRINKLED_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("pink_sprinkled_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> BLUE_SPRINKLED_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("blue_sprinkled_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> BLUE_MIXED_SPRINKLED_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("blue_mixed_sprinkled_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> RED_MIXED_SPRINKLED_SAND_PATCH_PLACED = SPlacedFeatures.registerKey("red_mixed_sprinkled_sand_patch_placed");
    public static final ResourceKey<PlacedFeature> SAND_TAG_PATCH_PLACED = SPlacedFeatures.registerKey("sand_tag_patch_placed");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        SPlacedFeatures.register(context, BEACHGRASS_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.BEACHGRASS), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)1), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)16), (Object)PlacementUtils.f_195356_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, BEACHGRASS_FAN_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.BEACHGRASS_FAN), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)1), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)16), (Object)PlacementUtils.f_195356_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, SEA_HOLLY_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.SEA_HOLLY), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)1), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)6), (Object)PlacementUtils.f_195356_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, SEA_THRIFT_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.SEA_THRIFT), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)1), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)6), (Object)PlacementUtils.f_195356_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, COASTAL_LAVENDER_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.COASTAL_LAVENDER), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)1), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)6), (Object)PlacementUtils.f_195356_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, COASTAL_WILDFLOWER_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.COASTAL_WILDFLOWER), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)1), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)6), (Object)PlacementUtils.f_195356_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, ALGAE_BOULDER_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.ALGAE_BOULDER), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)8), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)1), (Object)PlacementUtils.f_195356_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, SEA_SHELL_LAND, configuredFeatures.m_255043_(SConfiguredFeatures.SEA_SHELLS), VegetationPlacements.m_195474_((int)2));
        SPlacedFeatures.register(context, SEA_GLASS, configuredFeatures.m_255043_(SConfiguredFeatures.SEA_GLASS), VegetationPlacements.m_195474_((int)2));
        SPlacedFeatures.register(context, SEA_STAR_LAND, configuredFeatures.m_255043_(SConfiguredFeatures.SEA_STARS), VegetationPlacements.m_195474_((int)1));
        SPlacedFeatures.register(context, JUMBLED_SHELLY_SAND_PATCH, configuredFeatures.m_255043_(SConfiguredFeatures.JUMBLED_SHELLY_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, SCATTERED_SHELLY_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.SCATTERED_SHELLY_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, MIXED_SHELLY_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.MIXED_SHELLY_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, GRAVELY_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.GRAVELY_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, ROCKY_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.ROCKY_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, RED_SPRINKLED_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.RED_SPRINKLED_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, PURPLE_SPRINKLED_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.PURPLE_SPRINKLED_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, PINK_SPRINKLED_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.PINK_SPRINKLED_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, BLUE_SPRINKLED_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.BLUE_SPRINKLED_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, BLUE_MIXED_SPRINKLED_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.BLUE_MIXED_SPRINKLED_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, RED_MIXED_SPRINKLED_SAND_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.RED_MIXED_SPRINKLED_SAND_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)300), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, SAND_TAG_PATCH_PLACED, configuredFeatures.m_255043_(SConfiguredFeatures.SAND_TAG_PATCH), (List<PlacementModifier>)ImmutableList.of((Object)RarityFilter.m_191900_((int)1), (Object)PlacementUtils.f_195352_, (Object)BiomeFilter.m_191561_()));
        SPlacedFeatures.register(context, FLOATSOME, configuredFeatures.m_255043_(SConfiguredFeatures.FLOATSOME), VegetationPlacements.m_195474_((int)1));
    }

    public static List<PlacementModifier> worldSurfaceSquaredWithCount(int pCount) {
        return List.of(CountPlacement.m_191628_((int)pCount), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)ItemModelGenerator.prefix(name));
    }

    private static RegistryObject<PlacedFeature> registerPlacedFeature(String name, Supplier<PlacedFeature> feature) {
        placedFeatureList.add(name);
        return PLACED_FEATURES.register(name, feature);
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

