/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESHUDActivation;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.hud.TESHudPosition;
import org.apache.commons.lang3.tuple.Pair;

public final class TESConfig
implements net.tslat.tes.api.TESConfig {
    private final ForgeConfigSpec.FloatValue entityTrackingDistance;
    private final ForgeConfigSpec.IntValue cacheCleanFrequency;
    private final ForgeConfigSpec.BooleanValue hudEnabled;
    private final ForgeConfigSpec.EnumValue<TESHudPosition> hudRenderPosition;
    private final ForgeConfigSpec.IntValue hudPositionLeftAdjust;
    private final ForgeConfigSpec.IntValue hudPositionTopAdjust;
    private final ForgeConfigSpec.FloatValue hudTargetDistance;
    private final ForgeConfigSpec.IntValue hudTargetGracePeriod;
    private final ForgeConfigSpec.BooleanValue hudEntityRender;
    private final ForgeConfigSpec.BooleanValue hudPreventEntityOverflow;
    private final ForgeConfigSpec.EnumValue<TESHud.BarRenderType> hudHealthRenderType;
    private final ForgeConfigSpec.EnumValue<TESClientUtil.TextRenderType> hudHealthFontStyle;
    private final ForgeConfigSpec.BooleanValue hudHealthBarSegments;
    private final ForgeConfigSpec.IntValue hudHealthBarLength;
    private final ForgeConfigSpec.BooleanValue hudEntityDamageTint;
    private final ForgeConfigSpec.BooleanValue hudEntityName;
    private final ForgeConfigSpec.BooleanValue hudEntityNamespace;
    private final ForgeConfigSpec.EnumValue<TESClientUtil.TextRenderType> hudEntityNameFontStyle;
    private final ForgeConfigSpec.BooleanValue hudBossesEnabled;
    private final ForgeConfigSpec.BooleanValue hudArmour;
    private final ForgeConfigSpec.EnumValue<TESClientUtil.TextRenderType> hudArmourFontStyle;
    private final ForgeConfigSpec.BooleanValue hudEntityIcons;
    private final ForgeConfigSpec.BooleanValue hudPotionIcons;
    private final ForgeConfigSpec.BooleanValue hudHorseStats;
    private final ForgeConfigSpec.FloatValue hudOpacity;
    private final ForgeConfigSpec.FloatValue hudBarFontBackingOpacity;
    private final ForgeConfigSpec.BooleanValue inWorldBarsEnabled;
    private final ForgeConfigSpec.BooleanValue inWorldHudForSelf;
    private final ForgeConfigSpec.EnumValue<TESHUDActivation> inWorldHUDActivation;
    private final ForgeConfigSpec.DoubleValue inWorldHUDActivationDistance;
    private final ForgeConfigSpec.FloatValue inWorldHudOpacity;
    private final ForgeConfigSpec.EnumValue<TESHud.BarRenderType> inWorldBarsRenderType;
    private final ForgeConfigSpec.EnumValue<TESClientUtil.TextRenderType> inWorldHudHealthFontStyle;
    private final ForgeConfigSpec.IntValue inWorldBarsLength;
    private final ForgeConfigSpec.BooleanValue inWorldBarsSegments;
    private final ForgeConfigSpec.BooleanValue inWorldHudEntityName;
    private final ForgeConfigSpec.BooleanValue inWorldHudEntityNamespace;
    private final ForgeConfigSpec.EnumValue<TESClientUtil.TextRenderType> inWorldHudEntityNameFontStyle;
    private final ForgeConfigSpec.BooleanValue inWorldHudBossesEnabled;
    private final ForgeConfigSpec.BooleanValue inWorldHudArmour;
    private final ForgeConfigSpec.EnumValue<TESClientUtil.TextRenderType> inWorldHudArmourFontStyle;
    private final ForgeConfigSpec.BooleanValue inWorldHudEntityIcons;
    private final ForgeConfigSpec.BooleanValue inWorldHudPotionIcons;
    private final ForgeConfigSpec.BooleanValue inWorldHudHorseStats;
    private final ForgeConfigSpec.BooleanValue inWorldHudNameOverride;
    private final ForgeConfigSpec.FloatValue inWorldHudManualVerticalOffset;
    private final ForgeConfigSpec.BooleanValue particlesEnabled;
    private final ForgeConfigSpec.EnumValue<TESClientUtil.TextRenderType> particleFontStyle;
    private final ForgeConfigSpec.IntValue defaultParticleLifespan;
    private final ForgeConfigSpec.IntValue particleDecimalPoints;
    private final ForgeConfigSpec.FloatValue particleScale;
    private final ForgeConfigSpec.BooleanValue verbalHealthParticles;
    private final ForgeConfigSpec.IntValue damageParticleColour;
    private final ForgeConfigSpec.IntValue healParticleColour;
    private final ForgeConfigSpec.BooleanValue teamBasedDamageParticleColours;

    public TESConfig(ForgeConfigSpec.Builder config) {
        config.push("General Settings");
        this.entityTrackingDistance = config.comment("How close (in blocks) entities should be before TES starts tracking them").translation("config.tes.general.entityTrackingDistance").defineInRange("entityTrackingDistance", 64.0f, 8.0f, 512.0f);
        this.cacheCleanFrequency = config.comment("How frequently TES should clear out its tracking cache. Generally this should stay at default, but if you are noticing issues you can try adjusting it").translation("config.tes.general.cacheCleanFrequency").defineInRange("cacheCleanFrequency", 400, 20, Integer.MAX_VALUE);
        config.pop();
        config.push("HUD Settings");
        this.hudEnabled = config.comment("Whether the TES HUD should be enabled or not").translation("config.tes.hud.enabled").define("hudEnabled", true);
        this.hudRenderPosition = config.comment("What position the TES HUD should render in").translation("config.tes.hud.renderPosition").defineEnum("hudRenderPosition", (Enum)TESHudPosition.TOP_LEFT);
        this.hudPositionLeftAdjust = config.comment("Manually adjust the left-offset rendering position of the TES HUD").translation("config.tes.hud.leftOffset").defineInRange("hudPositionLeftAdjust", 0, -100000, 100000);
        this.hudPositionTopAdjust = config.comment("Manually adjust the top-offset rendering position of the TES HUD").translation("config.tes.hud.topOffset").defineInRange("hudPositionTopAdjust", 0, -100000, 100000);
        this.hudTargetDistance = config.comment(new String[]{"How close (in blocks) the player has to be to render a HUD for an entity under the crosshairs", "Larger values may cost more performance"}).translation("config.tes.hud.targetDistance").defineInRange("hudTargetDistance", 64.0f, 4.0f, 256.0f);
        this.hudTargetGracePeriod = config.comment("How long (in ticks) after looking away from an entity before its HUD should stop rendering").translation("config.tes.hud.targetGracePeriod").defineInRange("hudTargetGracePeriod", 10, 0, Integer.MAX_VALUE);
        this.hudEntityRender = config.comment("Whether the TES HUD should render the entity's image").translation("config.tes.hud.entityRender").define("hudEntityRender", true);
        this.hudPreventEntityOverflow = config.comment("Whether the TES HUD should cull any overflow for entities that don't scale properly to their rendering frame").translation("config.tes.hud.preventEntityOverflow").define("hudPreventEntityIconOverflow", false);
        this.hudHealthRenderType = config.comment(new String[]{"Select the health render type for the TES HUD", "Options:", "NUMERIC - Use numeric values for health only", "BAR - Use a health-bar style render", "BAR_ICONS - Display in the BAR style, but with the health numerically displayed in the stats icons row", "COMBINED - Use a health-bar style render with numeric values overlaid"}).translation("config.tes.hud.healthRenderType").defineEnum("healthRenderType", (Enum)TESHud.BarRenderType.COMBINED);
        this.hudHealthFontStyle = config.comment("What style TES font should render in for entity health in the HUD (if applicable)").translation("config.tes.hud.healthRenderType.fontStyle").defineEnum("hudHealthFontStyle", (Enum)TESClientUtil.TextRenderType.NORMAL);
        this.hudHealthBarSegments = config.comment("Set whether the TES HUD health bar should render bar-segments").translation("config.tes.hud.healthBarSegments").define("hudHealthBarSegments", true);
        this.hudHealthBarLength = config.comment("Set how long the TES HUD health bar should be").translation("config.tes.hud.healthBarLength").defineInRange("hudHealthBarLength", 100, 10, Integer.MAX_VALUE);
        this.hudEntityDamageTint = config.comment("Set whether the TES HUD's entity icon should keep the red 'tint' entities get when the real entity takes damage or not").translation("config.tes.hud.entityDamageTint").define("hudEntityDamageTint", false);
        this.hudEntityName = config.comment("Whether the TES HUD should render the entity's name").translation("config.tes.hud.entityName").define("hudEntityName", true);
        this.hudEntityNamespace = config.comment("Whether the TES HUD should render the entity's mod ID under its name").translation("config.tes.hud.entityNamespace").define("hudEntityNamespace", false);
        this.hudEntityNameFontStyle = config.comment("What style TES font should render in for entity names in the HUD").translation("config.tes.hud.entityName.fontStyle").defineEnum("hudEntityNameFontStyle", (Enum)TESClientUtil.TextRenderType.DROP_SHADOW);
        this.hudBossesEnabled = config.comment("Whether the TES HUD should render if the entity is a boss (they usually have their own boss bars)").translation("config.tes.hud.bossesEnabled").define("hudBossesEnabled", true);
        this.hudArmour = config.comment("Whether the TES HUD should render the entity's armour and toughness").translation("config.tes.hud.armour").define("hudArmour", true);
        this.hudArmourFontStyle = config.comment("What style TES font should render in for entity armour values in the HUD").translation("config.tes.hud.armour.fontStyle").defineEnum("hudArmourFontStyle", (Enum)TESClientUtil.TextRenderType.DROP_SHADOW);
        this.hudEntityIcons = config.comment("Whether the TES HUD should render the entity's alignment icons").translation("config.tes.hud.entityIcons").define("hudEntityIcons", true);
        this.hudPotionIcons = config.comment("Whether the TES HUD should render the entity's effect icons").translation("config.tes.hud.potionIcons").define("hudPotionIcons", true);
        this.hudHorseStats = config.comment("Whether the TES HUD should render horses' stats").translation("config.tes.hud.horseStats").define("hudHorseStats", true);
        this.hudOpacity = config.comment("Set how opaque the TES HUD should be, overall. The lower the value, the more transparent the HUD will be").translation("config.tes.hud.opacity").defineInRange("hudOpacity", 1.0f, 0.0f, 1.0f);
        this.hudBarFontBackingOpacity = config.comment("Set how opaque the background behind the text on TES bars, if a render type is set that renders text").translation("config.tes.hud.barFontBackingOpacity").defineInRange("hudBarFontBackingOpacity", 0.5f, 0.0f, 1.0f);
        config.pop();
        config.push("In-World Bars Settings");
        this.inWorldBarsEnabled = config.comment("Whether TES should do in-world entity status bars").translation("config.tes.inWorldHud.enabled").define("inWorldBarsEnabled", true);
        this.inWorldHudForSelf = config.comment("Whether the TES in-world HUD should be enabled for the player or not").translation("config.tes.hud.self").define("inWorldHudForSelf", false);
        this.inWorldHUDActivation = config.comment(new String[]{"When the TES in-world status bars should render", "Options:", "ALWAYS - Any entity currently visible", "NEARBY_ONLY - Only entities nearby", "DAMAGED_ONLY - Only entities that have less than full health", "DAMAGED_AND_NEARBY - Only entities that are nearby and have less than full health", "LOOKING_AT - Only the currently targeted entity", "LOOKING_AT_AND_DAMAGED - Only the currently targeted entity, if it has less than full health", "LOOKING_AT_NEARBY_AND_DAMAGED - Only the currently targeted entity if it is nearby and has less than full health", "NOT_LOOKING_AT - Only when the entity isn't the one being rendered for the on-screen HUD", "NOT_LOOKING_AT_AND_DAMAGED - Only if not the currently targeted entity, if it has less than full health", "NOT_LOOKING_AT_NEARBY_AND_DAMAGED - Only if not the currently targeted entity, it is nearby and has less than full health"}).translation("config.tes.inWorldHud.activation").defineEnum("inWorldHudActivation", (Enum)TESHUDActivation.DAMAGED_AND_NEARBY);
        this.inWorldHUDActivationDistance = config.comment("Set the distance in which you can be for the 'NEARBY' config activation values to take effect").translation("config.tes.inWorldHud.activationDistance").defineInRange("inWorldHUDActivationDistance", 16.0, 0.0, 1024.0);
        this.inWorldBarsRenderType = config.comment(new String[]{"Select the bar render type for the in-game TES entity status HUD", "Options:", "NUMERIC - Use numeric values only", "BAR - Use a health-bar style render", "BAR_ICONS - Display in the BAR style, but with the health numerically displayed in the stats icons row", "COMBINED - Use a health-bar style render with numeric values overlaid"}).translation("config.tes.inWorldHud.barsRenderType").defineEnum("inWorldBarsRenderType", (Enum)TESHud.BarRenderType.BAR);
        this.inWorldHudHealthFontStyle = config.comment("What style TES font should render in for entity health in the in-world HUD (if applicable)").translation("config.tes.inWorldHud.health.fontStyle").defineEnum("inWorldHudHealthFontStyle", (Enum)TESClientUtil.TextRenderType.NORMAL);
        this.inWorldHudOpacity = config.comment("How opaque the TES in-world entity HUD should be.").translation("config.tes.inWorldHud.opacity").defineInRange("inWorldHudOpacity", 1.0f, 0.0f, 1.0f);
        this.inWorldBarsLength = config.comment("Set how long the TES in-world entity status bars should be").translation("config.tes.inWorldHud.barLength").defineInRange("inWorldBarsLength", 50, 10, Integer.MAX_VALUE);
        this.inWorldBarsSegments = config.comment("Whether the in-world entity status bars should be segmented").translation("config.tes.inWorldHud.barSegments").define("inWorldBarsSegments", true);
        this.inWorldHudEntityName = config.comment("Whether the in-world entity status HUD should render the entity's name").translation("config.tes.inWorldHud.entityName").define("inWorldHudEntityName", false);
        this.inWorldHudEntityNamespace = config.comment("Whether the in-world entity status HUD should render the entity's mod ID under its name").translation("config.tes.inWorldHud.entityNamespace").define("inWorldHudEntityNamespace", false);
        this.inWorldHudBossesEnabled = config.comment("Whether the in-world entity status HUD should render if the entity is a boss (they usually have their own boss bars)").translation("config.tes.hud.inWorldHud.bossesEnabled").define("inWorldHudBossesEnabled", true);
        this.inWorldHudEntityNameFontStyle = config.comment("What style TES font should render in for entity names in the in-world HUD").translation("config.tes.inWorldHud.entityName.fontStyle").defineEnum("inWorldHudEntityNameFontStyle", (Enum)TESClientUtil.TextRenderType.DROP_SHADOW);
        this.inWorldHudArmour = config.comment("Whether the in-world entity status HUD should render the entity's armour values").translation("config.tes.inWorldHud.armour").define("inWorldHudArmour", false);
        this.inWorldHudArmourFontStyle = config.comment("What style TES font should render in for entity armour values in the in-world HUD").translation("config.tes.inWorldHud.armour.fontStyle").defineEnum("inWorldHudArmourFontStyle", (Enum)TESClientUtil.TextRenderType.DROP_SHADOW);
        this.inWorldHudEntityIcons = config.comment("Whether the in-world entity status HUD should render the entity's alignment icons").translation("config.tes.inWorldHud.icons").define("inWorldHudEntityIcons", false);
        this.inWorldHudPotionIcons = config.comment("Whether the in-world entity status HUD should render the entity's effects icons").translation("config.tes.inWorldHud.potionIcons").define("inWorldHudPotionIcons", false);
        this.inWorldHudHorseStats = config.comment("Whether the in-world TES entity status HUD should include horse stats").translation("config.tes.inWorldHud.horseStats").define("inWorldHudHorseStats", false);
        this.inWorldHudNameOverride = config.comment("Whether the in-world TES entity status HUD should override vanilla name rendering").translation("config.tes.inWorldHud.nameOverride").define("inWorldHudNameOverride", true);
        this.inWorldHudManualVerticalOffset = config.comment("Set a manual vertical offset for the TES in-world HUD (in blocks) in the event of other mods doing overhead rendering").translation("config.tes.inWorldHud.manualVerticalOffset").defineInRange("inWorldHudManualVerticalOffset", 0.0f, Float.MIN_VALUE, Float.MAX_VALUE);
        config.pop();
        config.push("Particle Settings");
        this.particlesEnabled = config.comment("Whether TES should do particles for various status changes such as damage dealt or health healed").translation("config.tes.particle.enabled").define("tesParticlesEnabled", true);
        this.particleFontStyle = config.comment("What style TES particles' font should render in").translation("config.tes.particle.fontStyle").defineEnum("particleFontStyle", (Enum)TESClientUtil.TextRenderType.OUTLINED);
        this.defaultParticleLifespan = config.comment("How long (in ticks) TES particles should display for").translation("config.tes.particle.defaultLifespan").defineInRange("defaultParticleLifespan", 60, 5, 200);
        this.particleDecimalPoints = config.comment(new String[]{"How many decimals the numeric TES Particles should round to", "Or set to 0 to only use whole-numbers"}).translation("config.tes.particle.decimalPoints").defineInRange("particleDecimalPoints", 1, 0, 8);
        this.particleScale = config.comment("Scale modifier for TES-Particles. The higher the value, the larger the particles").translation("config.tes.particle.scale").defineInRange("particleScale", 1.0f, 0.0f, 10.0f);
        this.verbalHealthParticles = config.comment("Whether TES should do verbal health-status particles (E.G. INSTAKILL) in certain situations").translation("config.tes.particle.verbal").define("verbalHealthParticles", true);
        this.damageParticleColour = config.comment("What colour the damage-type particles should be. Value can be a packed int, byte, or hex value. Format is ARGB").translation("config.tes.particle.damageParticleColour").defineInRange("damageParticleColour", -65536, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.healParticleColour = config.comment("What colour the healing-type particles should be. Value can be a packed int, byte, or hex value. Format is ARGB").translation("config.tes.particle.healParticleColour").defineInRange("healParticleColour", -16711936, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.teamBasedDamageParticleColours = config.comment("Whether TES should change the colour of damage particles to the colour of the team that dealt the damage (if applicable)").translation("config.tes.particle.teamColours").define("teamBasedDamageParticleColours", false);
        config.pop();
    }

    @Override
    public double getEntityTrackingDistance() {
        return ((Float)this.entityTrackingDistance.get()).floatValue();
    }

    @Override
    public int getCacheCleanFrequency() {
        return (Integer)this.cacheCleanFrequency.get();
    }

    @Override
    public boolean hudEnabled() {
        return (Boolean)this.hudEnabled.get();
    }

    @Override
    public TESHudPosition hudRenderPosition() {
        return (TESHudPosition)((Object)this.hudRenderPosition.get());
    }

    @Override
    public int hudPositionLeftAdjust() {
        return (Integer)this.hudPositionLeftAdjust.get();
    }

    @Override
    public int hudPositionTopAdjust() {
        return (Integer)this.hudPositionTopAdjust.get();
    }

    @Override
    public double getHudTargetDistance() {
        return ((Float)this.hudTargetDistance.get()).floatValue();
    }

    @Override
    public int hudTargetGracePeriod() {
        return (Integer)this.hudTargetGracePeriod.get();
    }

    @Override
    public boolean hudEntityRender() {
        return (Boolean)this.hudEntityRender.get();
    }

    @Override
    public boolean hudPreventEntityOverflow() {
        return (Boolean)this.hudPreventEntityOverflow.get();
    }

    @Override
    public boolean hudEntityDamageOverlay() {
        return (Boolean)this.hudEntityDamageTint.get();
    }

    @Override
    public boolean hudEntityName() {
        return (Boolean)this.hudEntityName.get();
    }

    @Override
    public boolean hudEntityNamespace() {
        return (Boolean)this.hudEntityNamespace.get();
    }

    @Override
    public TESClientUtil.TextRenderType hudEntityNameFontStyle() {
        return (TESClientUtil.TextRenderType)((Object)this.hudEntityNameFontStyle.get());
    }

    @Override
    public boolean hudBossesEnabled() {
        return (Boolean)this.hudBossesEnabled.get();
    }

    @Override
    public boolean hudArmour() {
        return (Boolean)this.hudArmour.get();
    }

    @Override
    public TESClientUtil.TextRenderType hudArmourFontStyle() {
        return (TESClientUtil.TextRenderType)((Object)this.hudArmourFontStyle.get());
    }

    @Override
    public boolean hudEntityIcons() {
        return (Boolean)this.hudEntityIcons.get();
    }

    @Override
    public boolean hudPotionIcons() {
        return (Boolean)this.hudPotionIcons.get();
    }

    @Override
    public boolean hudHorseStats() {
        return (Boolean)this.hudHorseStats.get();
    }

    @Override
    public float hudOpacity() {
        return ((Float)this.hudOpacity.get()).floatValue();
    }

    @Override
    public float hudBarFontBackingOpacity() {
        return ((Float)this.hudBarFontBackingOpacity.get()).floatValue();
    }

    @Override
    public TESHud.BarRenderType hudHealthRenderType() {
        return (TESHud.BarRenderType)((Object)this.hudHealthRenderType.get());
    }

    @Override
    public TESClientUtil.TextRenderType hudHealthFontStyle() {
        return (TESClientUtil.TextRenderType)((Object)this.hudHealthFontStyle.get());
    }

    @Override
    public boolean hudHealthBarSegments() {
        return (Boolean)this.hudHealthBarSegments.get();
    }

    @Override
    public int hudHealthBarLength() {
        return (Integer)this.hudHealthBarLength.get();
    }

    @Override
    public boolean inWorldBarsEnabled() {
        return (Boolean)this.inWorldBarsEnabled.get();
    }

    @Override
    public boolean inWorldHudForSelf() {
        return (Boolean)this.inWorldHudForSelf.get();
    }

    @Override
    public TESHUDActivation inWorldHUDActivation() {
        return (TESHUDActivation)((Object)this.inWorldHUDActivation.get());
    }

    @Override
    public double inWorldHUDActivationDistance() {
        return (Double)this.inWorldHUDActivationDistance.get();
    }

    @Override
    public float inWorldHudOpacity() {
        return ((Float)this.inWorldHudOpacity.get()).floatValue();
    }

    @Override
    public TESHud.BarRenderType inWorldBarsRenderType() {
        return (TESHud.BarRenderType)((Object)this.inWorldBarsRenderType.get());
    }

    @Override
    public TESClientUtil.TextRenderType inWorldHudHealthFontStyle() {
        return (TESClientUtil.TextRenderType)((Object)this.inWorldHudHealthFontStyle.get());
    }

    @Override
    public int inWorldBarsLength() {
        return (Integer)this.inWorldBarsLength.get();
    }

    @Override
    public boolean inWorldBarsSegments() {
        return (Boolean)this.inWorldBarsSegments.get();
    }

    @Override
    public boolean inWorldHudEntityName() {
        return (Boolean)this.inWorldHudEntityName.get();
    }

    @Override
    public boolean inWorldHudEntityNamespace() {
        return (Boolean)this.inWorldHudEntityNamespace.get();
    }

    @Override
    public TESClientUtil.TextRenderType inWorldHudEntityNameFontStyle() {
        return (TESClientUtil.TextRenderType)((Object)this.inWorldHudEntityNameFontStyle.get());
    }

    @Override
    public boolean inWorldHudBossesEnabled() {
        return (Boolean)this.inWorldHudBossesEnabled.get();
    }

    @Override
    public boolean inWorldHudArmour() {
        return (Boolean)this.inWorldHudArmour.get();
    }

    @Override
    public TESClientUtil.TextRenderType inWorldHudArmourFontStyle() {
        return (TESClientUtil.TextRenderType)((Object)this.inWorldHudArmourFontStyle.get());
    }

    @Override
    public boolean inWorldHudEntityIcons() {
        return (Boolean)this.inWorldHudEntityIcons.get();
    }

    @Override
    public boolean inWorldHudPotionIcons() {
        return (Boolean)this.inWorldHudPotionIcons.get();
    }

    @Override
    public boolean inWorldHudHorseStats() {
        return (Boolean)this.inWorldHudHorseStats.get();
    }

    @Override
    public boolean inWorldHudNameOverride() {
        return (Boolean)this.inWorldHudNameOverride.get();
    }

    @Override
    public float inWorldHudManualVerticalOffset() {
        return ((Float)this.inWorldHudManualVerticalOffset.get()).floatValue();
    }

    @Override
    public boolean particlesEnabled() {
        return (Boolean)this.particlesEnabled.get();
    }

    @Override
    public TESClientUtil.TextRenderType particleFontStyle() {
        return (TESClientUtil.TextRenderType)((Object)this.particleFontStyle.get());
    }

    @Override
    public int defaultParticleLifespan() {
        return (Integer)this.defaultParticleLifespan.get();
    }

    @Override
    public int particleDecimalPoints() {
        return (Integer)this.particleDecimalPoints.get();
    }

    @Override
    public float getParticleScale() {
        return ((Float)this.particleScale.get()).floatValue();
    }

    @Override
    public boolean verbalHealthParticles() {
        return (Boolean)this.verbalHealthParticles.get();
    }

    @Override
    public int getDamageParticleColour() {
        return (Integer)this.damageParticleColour.get();
    }

    @Override
    public int getHealParticleColour() {
        return (Integer)this.healParticleColour.get();
    }

    @Override
    public boolean teamBasedDamageParticleColours() {
        return (Boolean)this.teamBasedDamageParticleColours.get();
    }

    public static void init() {
        Pair configSpec = new ForgeConfigSpec.Builder().configure(TESConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)configSpec.getRight());
        TESConstants.setConfig((net.tslat.tes.api.TESConfig)configSpec.getLeft());
    }
}

