/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.networking;

import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;
import net.tslat.tes.core.networking.packet.NewComponentParticlePacket;
import net.tslat.tes.core.networking.packet.NewNumericParticlePacket;
import net.tslat.tes.core.networking.packet.ParticleClaimPacket;
import net.tslat.tes.core.networking.packet.RequestEffectsPacket;
import net.tslat.tes.core.networking.packet.SyncEffectsPacket;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

public interface TESNetworking {
    public void requestEffectsSync(int var1);

    public void sendEffectsSync(ServerPlayer var1, int var2, Set<Holder<MobEffect>> var3, Set<Holder<MobEffect>> var4);

    public void sendEffectsSync(LivingEntity var1, Set<Holder<MobEffect>> var2, Set<Holder<MobEffect>> var3);

    public void sendParticle(ServerLevel var1, Vector3f var2, Component var3);

    public void sendParticle(LivingEntity var1, Component var2);

    public void sendParticle(ServerLevel var1, Vector3f var2, double var3, int var5);

    public void sendParticle(LivingEntity var1, double var2, int var4);

    public void sendParticleClaim(ResourceLocation var1, LivingEntity var2, Optional<CompoundTag> var3);

    public static void init() {
        TESNetworking.registerPacket(NewComponentParticlePacket.TYPE, NewComponentParticlePacket.CODEC, true);
        TESNetworking.registerPacket(NewNumericParticlePacket.TYPE, NewNumericParticlePacket.CODEC, true);
        TESNetworking.registerPacket(ParticleClaimPacket.TYPE, ParticleClaimPacket.CODEC, true);
        TESNetworking.registerPacket(RequestEffectsPacket.TYPE, RequestEffectsPacket.CODEC, false);
        TESNetworking.registerPacket(SyncEffectsPacket.TYPE, SyncEffectsPacket.CODEC, true);
    }

    public static <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerPacket(CustomPacketPayload.Type<P> payloadType, StreamCodec<B, P> codec, boolean isClientBound) {
        TESConstants.NETWORKING.registerPacketInternal(payloadType, codec, isClientBound);
    }

    @ApiStatus.Internal
    public <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerPacketInternal(CustomPacketPayload.Type<P> var1, StreamCodec<B, P> var2, boolean var3);
}

