/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3673;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9064;
import net.minecraft.class_9779;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESHudElement;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.element.BuiltinHudElements;
import net.tslat.tes.core.hud.element.TESHudEntityIcon;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;
import org.jetbrains.annotations.Nullable;

public class TESHud {
    private static final Map<String, TESHudElement> ELEMENTS = (Map)class_156.method_654(Collections.synchronizedMap(new Object2ObjectArrayMap()), map -> {
        map.put("EntityName", BuiltinHudElements::renderEntityName);
        map.put("HealthBar", BuiltinHudElements::renderEntityHealth);
        map.put("Armour", BuiltinHudElements::renderEntityArmour);
        map.put("Icons", BuiltinHudElements::renderEntityIcons);
        map.put("Effects", BuiltinHudElements::renderEntityEffects);
        map.put("HorseStats", BuiltinHudElements::renderHorseStats);
    });
    protected static final List<TESHudEntityIcon> ENTITY_ICONS = (List)class_156.method_654(new CopyOnWriteArrayList(), list -> list.addAll(List.of(TESHudEntityIcon.makeGeneric(TESClientUtil.PROPERTY_FIRE_IMMUNE, TESUtil::isFireImmune), TESHudEntityIcon.makeGeneric(TESClientUtil.PROPERTY_MELEE, TESUtil::isMeleeMob), TESHudEntityIcon.makeGeneric(TESClientUtil.PROPERTY_RANGED, TESUtil::isRangedMob), TESHudEntityIcon.makeGeneric(TESClientUtil.ENTITY_TYPE_AQUATIC, entity -> entity.method_5864().method_20210(class_3483.field_48288)), TESHudEntityIcon.makeGeneric(TESClientUtil.ENTITY_TYPE_ILLAGER, entity -> entity.method_5864().method_20210(class_3483.field_48287)), TESHudEntityIcon.makeGeneric(TESClientUtil.ENTITY_TYPE_ARTHROPOD, entity -> entity.method_5864().method_20210(class_3483.field_48289)), TESHudEntityIcon.makeGeneric(TESClientUtil.ENTITY_TYPE_UNDEAD, entity -> entity.method_5864().method_20210(class_3483.field_46232)))));
    private static TESHudElement[] INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
    private static WeakReference<class_1309> TARGET_ENTITY = new WeakReference<Object>(null);
    private static long TARGET_EXPIRY_TIME = -1L;

    public static void setTargetEntity(class_1309 entity) {
        TARGET_ENTITY = new WeakReference<class_1309>(entity);
        TARGET_EXPIRY_TIME = class_3532.method_15357((double)(class_3673.method_15974() * 20.0)) + 1 + TESAPI.getConfig().hudTargetGracePeriod();
    }

    @Nullable
    public static class_1309 getTargetEntity() {
        class_1309 target = (class_1309)TARGET_ENTITY.get();
        if (target != null && (target.method_31481() || target.method_37908() != class_310.method_1551().field_1687 || (long)class_3532.method_15357((double)(class_3673.method_15974() * 20.0)) > TARGET_EXPIRY_TIME)) {
            TARGET_ENTITY = new WeakReference<Object>(null);
            return null;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHudElement(String name, TESHudElement element) {
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            ELEMENTS.put(name, element);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeHudElement(String name) {
        AtomicBoolean removed = new AtomicBoolean(false);
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            removed.set(ELEMENTS.remove(name) != null);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
        return removed.get();
    }

    public static void addHudEntityIcon(TESHudEntityIcon icon) {
        ENTITY_ICONS.add(icon);
    }

    public static void renderForHud(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker) {
        class_1309 target = TESHud.getTargetEntity();
        if (target == null) {
            return;
        }
        if (!TESAPI.getConfig().hudEnabled() || class_310.method_1551().field_1690.field_1842 || !TESAPI.getConfig().hudBossesEnabled() && TESConstants.UTILS.isBossEntity(target)) {
            return;
        }
        float hudOpacity = TESAPI.getConfig().hudOpacity();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        TESAPI.getConfig().hudRenderPosition().adjustRenderForHudPosition(guiGraphics);
        RenderSystem.enableBlend();
        if (TESAPI.getConfig().hudEntityRender()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
            TESClientUtil.renderEntityIcon(guiGraphics, mc, deltaTracker, target, hudOpacity, true);
            poseStack.method_46416(40.0f, 0.0f, 0.0f);
        }
        poseStack.method_46416(0.0f, 2.0f, 0.0f);
        for (TESHudElement element : ELEMENTS.values()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
            int offset = element.render(guiGraphics, mc, deltaTracker, target, hudOpacity, false);
            if (offset <= 0) continue;
            poseStack.method_46416(0.0f, (float)(2 + offset), 0.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    public static void renderInWorld(class_4587 poseStack, class_1309 entity, class_9779 deltaTracker) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || !entityState.isValid()) {
            return;
        }
        entityState.markActive();
        if (!TESAPI.getConfig().inWorldBarsEnabled() || entity.method_24204().anyMatch(passenger -> passenger == class_310.method_1551().field_1724) && !TESAPI.getConfig().inWorldHudForSelf() || !TESAPI.getConfig().inWorldHUDActivation().test(entityState) || !TESAPI.getConfig().inWorldHudBossesEnabled() && TESConstants.UTILS.isBossEntity(entity)) {
            return;
        }
        float partialTick = deltaTracker.method_60637(!entity.method_37908().method_54719().method_54746((class_1297)entity));
        float hudOpacity = TESAPI.getConfig().inWorldHudOpacity();
        class_310 mc = class_310.method_1551();
        class_243 position = entity.method_30950(partialTick).method_1020(mc.field_1773.method_19418().method_19326()).method_1019(mc.method_1561().method_3953((class_1297)entity).method_23169((class_1297)entity, partialTick));
        poseStack.method_22903();
        class_243 nameTagOffset = entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_5705(partialTick));
        if (nameTagOffset == null) {
            nameTagOffset = class_243.field_1353;
        }
        poseStack.method_22904(position.field_1352, position.field_1351, position.field_1350);
        poseStack.method_22904(nameTagOffset.field_1352, nameTagOffset.field_1351 + 0.5, nameTagOffset.field_1350);
        poseStack.method_46416(0.0f, TESConstants.CONFIG.inWorldHudManualVerticalOffset(), 0.0f);
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22905(0.02f, 0.02f, 0.02f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
        class_332 guiGraphics = TESClientUtil.createInlineGuiGraphics(poseStack, mc.method_22940().method_23000());
        guiGraphics.method_51448().method_22903();
        for (TESHudElement element : INVERSE_ELEMENTS) {
            int offset = element.render(guiGraphics, mc, deltaTracker, entity, hudOpacity, true);
            if (offset <= 0) continue;
            guiGraphics.method_51448().method_46416(0.0f, (float)(-(2 + offset)), 0.0f);
        }
        guiGraphics.method_51452();
        guiGraphics.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    public static void pickNewEntity(float partialTick) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1692 != null) {
            class_1309 target = TESConstants.UTILS.getLivingEntityIfPossible(mc.field_1692);
            if (target != null && TESUtil.shouldTESHandleEntity(target, TESClientUtil.getClientPlayer())) {
                TESHud.setTargetEntity(target);
            }
        } else {
            class_238 hitBounds;
            class_243 cameraView;
            class_243 rayEnd;
            class_243 cameraPos;
            double targetingRange = TESAPI.getConfig().getHudTargetDistance();
            class_1297 cameraEntity = mc.method_1560();
            class_3966 hitResult = class_1675.method_18075((class_1297)cameraEntity, (class_243)(cameraPos = TESClientUtil.getCameraPosition()), (class_243)(rayEnd = cameraPos.method_1019((cameraView = cameraEntity.method_5828(partialTick)).method_18805(targetingRange, targetingRange, targetingRange))), (class_238)(hitBounds = cameraEntity.method_5829().method_18804(cameraView.method_1021(targetingRange)).method_1009(1.0, 1.0, 1.0)), entity -> !entity.method_7325() && entity.method_5863(), (double)(targetingRange * targetingRange));
            if (hitResult == null) {
                return;
            }
            class_1309 target = TESConstants.UTILS.getLivingEntityIfPossible(hitResult.method_17782());
            if (target == null || !TESUtil.shouldTESHandleEntity(target, TESClientUtil.getClientPlayer())) {
                return;
            }
            double entityHitClipDistanceSqr = hitResult.method_17784().method_1025(cameraPos);
            targetingRange = Math.sqrt(entityHitClipDistanceSqr);
            rayEnd = cameraPos.method_1019(cameraView.method_18805(targetingRange, targetingRange, targetingRange));
            class_3965 blockHitResult = cameraEntity.method_37908().method_17742(new class_3959(cameraPos, rayEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, cameraEntity));
            if (blockHitResult == null || blockHitResult.method_17783() == class_239.class_240.field_1333 || blockHitResult.method_17784().method_1025(cameraPos) > entityHitClipDistanceSqr) {
                TESHud.setTargetEntity(target);
            }
        }
    }

    public static List<TESHudEntityIcon> getEntityIcons() {
        return ENTITY_ICONS;
    }

    private static TESHudElement[] buildInverseElementArray(Collection<TESHudElement> elements) {
        TESHudElement[] array = new TESHudElement[elements.size()];
        int i = elements.size() - 1;
        for (TESHudElement element : elements) {
            array[i--] = element;
        }
        return array;
    }

    public static enum BarRenderType {
        NUMERIC,
        BAR,
        BAR_ICONS,
        COMBINED;

    }
}

