/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.mixin.client.GuiGraphicsAccessor;
import org.joml.Matrix4f;

public final class TESClientUtil {
    public static final ResourceLocation VANILLA_GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    public static final ResourceLocation CREATIVE_INVENTORY_TEXTURE = new ResourceLocation("textures/gui/container/creative_inventory/tab_inventory.png");

    @Deprecated(forRemoval=true)
    public static void renderCenteredText(GuiGraphics guiGraphics, String text, float x, float y, int colour) {
        TESClientUtil.renderCenteredText(guiGraphics, (Component)Component.m_237113_((String)text), x, y, colour);
    }

    @Deprecated(forRemoval=true)
    public static void renderCenteredText(GuiGraphics guiGraphics, Component text, float x, float y, int colour) {
        TESClientUtil.drawText(guiGraphics, Minecraft.m_91087_().f_91062_, text, x - (float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) / 2.0f, y + 4.0f, colour);
    }

    public static void centerTextForRender(Component text, float x, float y, BiConsumer<Float, Float> renderRunnable) {
        Float f = Float.valueOf(x - (float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) / 2.0f);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        renderRunnable.accept(f, Float.valueOf(y + (float)(9 - 1) / 2.0f));
    }

    public static void positionFacingCamera(PoseStack poseStack) {
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
    }

    public static void prepRenderForTexture(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void constructBarRender(GuiGraphics guiGraphics, int x, int y, int width, int v, float percentComplete, boolean withBarOverlay, float opacity) {
        int percentPixels = Math.round(percentComplete * (float)width);
        int midBarWidth = width - 10;
        TESClientUtil.drawSimpleTexture(guiGraphics, x, y, Math.min(5, percentPixels), 5, 0.0f, v, 256);
        if (percentPixels > 5) {
            if (midBarWidth > 0) {
                TESClientUtil.drawSimpleTexture(guiGraphics, x + 5, y, Math.min(midBarWidth, percentPixels - 5), 5, 5.0f, v, 256);
            }
            if (percentPixels > width - 5) {
                TESClientUtil.drawSimpleTexture(guiGraphics, x + 5 + midBarWidth, y, Math.min(5, percentPixels - 5), 5, 177.0f, v, 256);
            }
        }
        if (withBarOverlay && width > 10) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * opacity));
            TESClientUtil.drawSimpleTexture(guiGraphics, x, y, width, 5, 0.0f, 80.0f, 182, 5, 256, 256);
        }
    }

    public static void renderEntityIcon(GuiGraphics guiGraphics, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean includeFrame) {
        float scale = 0.04f * (float)Math.pow(Math.min(30.0f / entity.m_20205_(), 40.0f / entity.m_20206_()), 0.95f);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        if (includeFrame) {
            TESClientUtil.prepRenderForTexture(CREATIVE_INVENTORY_TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f * opacity));
            TESClientUtil.drawSimpleTexture(guiGraphics, 2, 2, 34, 45, 72.0f, 5.0f, 256);
            poseStack.m_252880_(20.0f, 25.0f, 0.0f);
            poseStack.m_85841_(-20.0f, -20.0f, 20.0f);
        }
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(0.0f, entity.m_20206_() * -0.5f, entity.m_20205_());
        float yBodyRotPrev = entity.f_20883_;
        float yRotPrev = entity.m_146908_();
        float xRotPrev = entity.m_146909_();
        float yHeadRotOldPrev = entity.f_20886_;
        float yHeadRotPrev = entity.f_20885_;
        int hurtTicks = entity.f_20916_;
        float attackTimePrev = entity.f_20921_;
        float attackTimeOldPrev = entity.f_20920_;
        entity.m_146922_(22.5f);
        entity.m_146926_(0.0f);
        entity.f_20883_ = 22.5f;
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        entity.f_20916_ = TESAPI.getConfig().hudEntityDamageOverlay() ? entity.f_20916_ : 0;
        entity.f_20921_ = 0.0f;
        entity.f_20920_ = 0.0f;
        Lighting.m_166384_();
        RenderSystem.runAsFancy(() -> TESClientUtil.renderEntityRaw(poseStack, entity, partialTick, 0.0f, 0xF000F0, (MultiBufferSource)bufferSource));
        bufferSource.m_109911_();
        Lighting.m_84931_();
        entity.m_146922_(yRotPrev);
        entity.m_146926_(xRotPrev);
        entity.f_20883_ = yBodyRotPrev;
        entity.f_20885_ = yHeadRotPrev;
        entity.f_20886_ = yHeadRotOldPrev;
        entity.f_20916_ = hurtTicks;
        entity.f_20921_ = attackTimePrev;
        entity.f_20920_ = attackTimeOldPrev;
        poseStack.m_85849_();
    }

    public static <T extends Entity> void renderEntityRaw(PoseStack poseStack, T entity, float partialTick, float rotYaw, int packedLight, MultiBufferSource bufferSource) {
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = entityRenderDispatcher.m_114382_(entity);
        try {
            Vec3 renderOffset = entityRenderer.m_7860_(entity, partialTick);
            poseStack.m_85836_();
            poseStack.m_85837_(renderOffset.f_82479_, renderOffset.f_82480_, renderOffset.f_82481_);
            entityRenderer.m_7392_(entity, rotYaw, 1.0f, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
        catch (Exception ex) {
            CrashReport wrappedReport = CrashReport.m_127521_((Throwable)ex, (String)"Rendering entity in world");
            CrashReportCategory entityReportCategory = wrappedReport.m_127514_("Entity being rendered");
            entity.m_7976_(entityReportCategory);
            CrashReportCategory rendererReportCategory = wrappedReport.m_127514_("Renderer details");
            rendererReportCategory.m_128159_("Assigned renderer", (Object)entityRenderer);
            throw new ReportedException(wrappedReport);
        }
    }

    public static void drawSimpleTexture(GuiGraphics guiGraphics, int posX, int posY, int width, int height, float u, float v, int pngSize) {
        TESClientUtil.drawSimpleTexture(guiGraphics, posX, posY, width, height, u, v, pngSize, pngSize);
    }

    public static void drawSimpleTexture(GuiGraphics guiGraphics, int posX, int posY, int width, int height, float u, float v, int pngWidth, int pngHeight) {
        TESClientUtil.drawSimpleTexture(guiGraphics, posX, posY, width, height, u, v, width, height, pngWidth, pngHeight);
    }

    public static void drawSimpleTexture(GuiGraphics guiGraphics, int posX, int posY, int width, int height, float u, float v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        Matrix4f pose = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        float widthRatio = 1.0f / (float)pngWidth;
        float heightRatio = 1.0f / (float)pngHeight;
        RenderSystem.enableBlend();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(pose, (float)posX, (float)posY, 0.0f).m_7421_(u * widthRatio, v * heightRatio).m_5752_();
        buffer.m_252986_(pose, (float)posX, (float)posY + (float)height, 0.0f).m_7421_(u * widthRatio, (v + (float)vHeight) * heightRatio).m_5752_();
        buffer.m_252986_(pose, (float)posX + (float)width, (float)posY + (float)height, 0.0f).m_7421_((u + (float)uWidth) * widthRatio, (v + (float)vHeight) * heightRatio).m_5752_();
        buffer.m_252986_(pose, (float)posX + (float)width, (float)posY, 0.0f).m_7421_((u + (float)uWidth) * widthRatio, v * heightRatio).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void drawSprite(GuiGraphics guiGraphics, TextureAtlasSprite sprite, int posX, int posY, int width, int height, int u, int v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        Matrix4f pose = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        float uMin = sprite.m_118367_((double)((float)u / (float)pngWidth));
        float uMax = sprite.m_118367_((double)((float)(u + uWidth) / (float)pngWidth));
        float vMin = sprite.m_118393_((double)((float)v / (float)pngHeight));
        float vMax = sprite.m_118393_((double)((float)(v + vHeight) / (float)pngHeight));
        RenderSystem.enableBlend();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(pose, (float)posX, (float)posY, 0.0f).m_7421_(uMin, vMin).m_5752_();
        buffer.m_252986_(pose, (float)posX, (float)posY + (float)height, 0.0f).m_7421_(uMin, vMax).m_5752_();
        buffer.m_252986_(pose, (float)posX + (float)width, (float)posY + (float)height, 0.0f).m_7421_(uMax, vMax).m_5752_();
        buffer.m_252986_(pose, (float)posX + (float)width, (float)posY, 0.0f).m_7421_(uMax, vMin).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void drawText(GuiGraphics guiGraphics, Font font, String text, float x, float y, int colour) {
        TESClientUtil.drawText(guiGraphics, font, (Component)Component.m_237113_((String)text), x, y, colour);
    }

    public static void drawText(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int colour) {
        TESClientUtil.renderDefaultStyleText(font, guiGraphics.m_280168_().m_85850_().m_252922_(), text.m_7532_(), x, y, colour, TextRenderType.NORMAL.getOutlineColour(colour), 0xF000F0, guiGraphics.m_280091_());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderDefaultStyleText(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        fontRenderer.m_272191_(text, x, y, colour, false, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, outlineColour, packedLight);
    }

    public static void drawTextWithShadow(GuiGraphics guiGraphics, Font font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithShadow(guiGraphics, font, (Component)Component.m_237113_((String)text), x, y, colour);
    }

    public static void drawTextWithShadow(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int colour) {
        TESClientUtil.renderDropShadowStyleText(font, guiGraphics.m_280168_().m_85850_().m_252922_(), text.m_7532_(), x, y, colour, TextRenderType.DROP_SHADOW.getOutlineColour(colour), 0xF000F0, guiGraphics.m_280091_());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderDropShadowStyleText(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        int borderColour = (outlineColour & 0xFC000000) == 0 ? outlineColour | 0xFF000000 : outlineColour;
        Font font = fontRenderer;
        Objects.requireNonNull(font);
        Font.StringRenderOutput outlineOutput = new Font.StringRenderOutput(font, (MultiBufferSource)bufferSource, 0.0f, 0.0f, borderColour, false, pose, Font.DisplayMode.NORMAL, packedLight);
        float[] newX = new float[]{x};
        text.m_13731_((currentPosition, style, codePoint) -> {
            GlyphInfo glyphInfo = fontRenderer.m_92863_(style.m_131192_()).m_243128_(codePoint, fontRenderer.f_242994_);
            outlineOutput.f_92948_ = newX[0] + glyphInfo.m_5645_();
            outlineOutput.f_92949_ = y + glyphInfo.m_5645_();
            newX[0] = newX[0] + glyphInfo.m_83827_(style.m_131154_());
            return outlineOutput.m_6411_(currentPosition, style.m_178520_(borderColour), codePoint);
        });
        Font font2 = fontRenderer;
        Objects.requireNonNull(font2);
        Font.StringRenderOutput output = new Font.StringRenderOutput(font2, (MultiBufferSource)bufferSource, x, y, (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour, false, pose, Font.DisplayMode.POLYGON_OFFSET, packedLight);
        text.m_13731_((FormattedCharSink)output);
        output.m_92961_(0, x);
    }

    public static void drawTextWithGlow(GuiGraphics guiGraphics, Font font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithGlow(guiGraphics, font, (Component)Component.m_237113_((String)text), x, y, colour);
    }

    public static void drawTextWithGlow(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int colour) {
        TESClientUtil.renderGlowingStyleText(font, guiGraphics.m_280168_().m_85850_().m_252922_(), text.m_7532_(), x, y, colour, TextRenderType.GLOWING.getOutlineColour(colour), 0xF000F0, guiGraphics.m_280091_());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderGlowingStyleText(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        fontRenderer.m_168645_(text, x, y, colour, outlineColour, pose, (MultiBufferSource)bufferSource, packedLight);
    }

    public static void drawTextWithOutline(GuiGraphics guiGraphics, Font font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithOutline(guiGraphics, font, (Component)Component.m_237113_((String)text), x, y, colour);
    }

    public static void drawTextWithOutline(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int colour) {
        TESClientUtil.renderOutlineStyleText(font, guiGraphics.m_280168_().m_85850_().m_252922_(), text.m_7532_(), x, y, colour, TextRenderType.OUTLINED.getOutlineColour(colour), 0xF000F0, guiGraphics.m_280091_());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderOutlineStyleText(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        int borderColour = (outlineColour & 0xFC000000) == 0 ? outlineColour | 0xFF000000 : outlineColour;
        Font font = fontRenderer;
        Objects.requireNonNull(font);
        Font.StringRenderOutput outlineOutput = new Font.StringRenderOutput(font, (MultiBufferSource)bufferSource, 0.0f, 0.0f, borderColour, false, pose, Font.DisplayMode.NORMAL, packedLight);
        for (float deltaX = -1.0f; deltaX <= 1.0f; deltaX += 1.0f) {
            for (float deltaY = -1.0f; deltaY <= 1.0f; deltaY += 1.0f) {
                if (!(deltaX == 0.0f ^ deltaY == 0.0f)) continue;
                float[] newX = new float[]{x};
                float offsetX = deltaX;
                float offsetY = deltaY;
                text.m_13731_((currentPosition, style, codePoint) -> {
                    GlyphInfo glyphInfo = fontRenderer.m_92863_(style.m_131192_()).m_243128_(codePoint, fontRenderer.f_242994_);
                    outlineOutput.f_92948_ = newX[0] + offsetX * glyphInfo.m_5645_() * 0.6f;
                    outlineOutput.f_92949_ = y + offsetY * glyphInfo.m_5645_() * 0.6f;
                    newX[0] = newX[0] + glyphInfo.m_83827_(style.m_131154_());
                    return outlineOutput.m_6411_(currentPosition, style.m_178520_(borderColour), codePoint);
                });
            }
        }
        Font font2 = fontRenderer;
        Objects.requireNonNull(font2);
        Font.StringRenderOutput output = new Font.StringRenderOutput(font2, (MultiBufferSource)bufferSource, x, y, (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour, false, pose, Font.DisplayMode.POLYGON_OFFSET, packedLight);
        text.m_13731_((FormattedCharSink)output);
        output.m_92961_(0, x);
    }

    public static void drawColouredSquare(GuiGraphics guiGraphics, int posX, int posY, int width, int height, int colour) {
        guiGraphics.m_280509_(posX, posY, posX + width, posY + height, colour);
    }

    public static String translateKey(String key, Object ... args) {
        return I18n.m_118938_((String)key, (Object[])args);
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static Vec3 getCameraPosition() {
        return Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
    }

    public static Vec3 getClosestEntityPosition(Entity entity) {
        Vec3 cameraPos = TESClientUtil.getCameraPosition();
        Vec3 angle = TESClientUtil.getClientPlayer().m_20154_();
        return entity.m_20191_().m_82371_(cameraPos, cameraPos.m_82549_(angle.m_82490_(500.0))).orElseGet(() -> new Vec3((double)(Mth.m_14089_((float)((float)angle.f_82479_)) * entity.m_20205_() * 0.5f), Mth.m_14008_((double)cameraPos.f_82480_, (double)entity.m_20186_(), (double)entity.m_20227_(1.0)), (double)(Mth.m_14031_((float)((float)angle.f_82481_)) * entity.m_20205_() * 0.5f)));
    }

    public static GuiGraphics createInlineGuiGraphics(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        GuiGraphics guiGraphics = new GuiGraphics(Minecraft.m_91087_(), bufferSource);
        guiGraphics.m_280168_().m_252931_(poseStack.m_85850_().m_252922_());
        return guiGraphics;
    }

    public static int multiplyARGBColour(int colour, float multiplier) {
        return FastColor.ARGB32.m_13660_((int)(colour >>> 24), (int)(Mth.m_14143_((float)((float)(colour >> 16 & 0xFF) * multiplier)) & 0xFF), (int)(Mth.m_14143_((float)((float)(colour >> 8 & 0xFF) * multiplier)) & 0xFF), (int)(Mth.m_14143_((float)((float)(colour & 0xFF) * multiplier)) & 0xFF));
    }

    public static enum TextRenderType {
        NORMAL(TESClientUtil::renderDefaultStyleText, colour -> 0),
        DROP_SHADOW(TESClientUtil::renderDropShadowStyleText, colour -> TESClientUtil.multiplyARGBColour(colour, 0.25f)),
        GLOWING(TESClientUtil::renderGlowingStyleText, colour -> TESClientUtil.multiplyARGBColour(colour, 0.25f)),
        OUTLINED(TESClientUtil::renderOutlineStyleText, colour -> 0);

        private final StyledTextRenderer style;
        private final Int2IntFunction outlineColourGenerator;

        private TextRenderType(StyledTextRenderer style, Int2IntFunction outlineColourGenerator) {
            this.style = style;
            this.outlineColourGenerator = outlineColourGenerator;
        }

        public void render(Font fontRenderer, PoseStack poseStack, Component component, float x, float y, int colour, MultiBufferSource.BufferSource bufferSource) {
            this.render(fontRenderer, poseStack.m_85850_().m_252922_(), component.m_7532_(), x, y, colour, this.outlineColourGenerator.applyAsInt(colour), 0xF000F0, bufferSource);
        }

        public void render(Font fontRenderer, Matrix4f pose, FormattedCharSequence text, float x, float y, int colour, int outlineColour, int packedLight, MultiBufferSource.BufferSource bufferSource) {
            this.style.render(fontRenderer, pose, text, x, y, colour, outlineColour, packedLight, bufferSource);
        }

        public int getOutlineColour(int colour) {
            return this.outlineColourGenerator.applyAsInt(colour);
        }
    }

    @FunctionalInterface
    public static interface StyledTextRenderer {
        public void render(Font var1, Matrix4f var2, FormattedCharSequence var3, float var4, float var5, int var6, int var7, int var8, MultiBufferSource.BufferSource var9);
    }
}

