/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.networking.NewComponentParticlePacket;
import net.tslat.tes.networking.NewNumericParticlePacket;
import net.tslat.tes.networking.ParticleClaimPacket;
import net.tslat.tes.networking.RequestEffectsPacket;
import net.tslat.tes.networking.SyncEffectsPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public final class TESNetworking
implements net.tslat.tes.core.networking.TESNetworking {
    private static final String REV = "1";
    private static final Predicate<String> ABSENT_OR_EQUAL = NetworkRegistry.acceptMissingOr("1"::equals);
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tslatentitystatus", "tes_packets"), () -> "1", ABSENT_OR_EQUAL, ABSENT_OR_EQUAL);

    public static void init() {
        int id = 0;
        INSTANCE.registerMessage(id++, RequestEffectsPacket.class, RequestEffectsPacket::encode, RequestEffectsPacket::decode, RequestEffectsPacket::handleMessage);
        INSTANCE.registerMessage(id++, SyncEffectsPacket.class, SyncEffectsPacket::encode, SyncEffectsPacket::decode, SyncEffectsPacket::handleMessage);
        INSTANCE.registerMessage(id++, ParticleClaimPacket.class, ParticleClaimPacket::encode, ParticleClaimPacket::decode, ParticleClaimPacket::handleMessage);
        INSTANCE.registerMessage(id++, NewComponentParticlePacket.class, NewComponentParticlePacket::encode, NewComponentParticlePacket::decode, NewComponentParticlePacket::handleMessage);
        INSTANCE.registerMessage(id++, NewNumericParticlePacket.class, NewNumericParticlePacket::encode, NewNumericParticlePacket::decode, NewNumericParticlePacket::handleMessage);
    }

    @Override
    public void requestEffectsSync(int entityId) {
        if (!TESAPI.getConfig().isSyncingEffects()) {
            return;
        }
        INSTANCE.sendToServer((Object)new RequestEffectsPacket(entityId));
    }

    @Override
    public void sendEffectsSync(ServerPlayer player, int entityId, Set<ResourceLocation> toAdd, Set<ResourceLocation> toRemove) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncEffectsPacket(entityId, toAdd, toRemove));
    }

    @Override
    public void sendEffectsSync(LivingEntity targetedEntity, Set<ResourceLocation> toAdd, Set<ResourceLocation> toRemove) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetedEntity), (Object)new SyncEffectsPacket(targetedEntity.m_19879_(), toAdd, toRemove));
    }

    @Override
    public void sendParticle(Level level, Vector3f position, Component contents) {
        INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)position.x, (double)position.y, (double)position.z, (double)200.0, (ResourceKey)level.m_46472_())), (Object)new NewComponentParticlePacket(position, contents));
    }

    @Override
    public void sendParticle(LivingEntity targetedEntity, Component contents) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetedEntity), (Object)new NewComponentParticlePacket(targetedEntity, contents));
    }

    @Override
    public void sendParticle(Level level, Vector3f position, double value, int colour) {
        INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)position.x, (double)position.y, (double)position.z, (double)200.0, (ResourceKey)level.m_46472_())), (Object)new NewNumericParticlePacket(value, position, colour));
    }

    @Override
    public void sendParticle(LivingEntity targetedEntity, double value, int colour) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetedEntity), (Object)new NewNumericParticlePacket(value, new Vector3f((float)targetedEntity.m_20185_(), (float)targetedEntity.m_20188_(), (float)targetedEntity.m_20189_()), colour));
    }

    @Override
    public void sendParticleClaim(ResourceLocation claimantId, LivingEntity targetedEntity, @Nullable CompoundTag additionalData) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetedEntity), (Object)new ParticleClaimPacket(targetedEntity.m_19879_(), claimantId, additionalData));
    }
}

