/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.block.EnergyBlock;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESCrests;
import cn.leolezury.eternalstarlight.common.entity.attack.EnergizedFlame;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESServerBossEvent;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemChargeEndPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemChargePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemChargeStartPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemLaserBeamPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemSmashPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolemSummonFlamePhase;
import cn.leolezury.eternalstarlight.common.entity.living.goal.LookAtTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.RingExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESPoiTypes;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3988;
import net.minecraft.class_4153;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import net.minecraft.class_8111;

public class StarlightGolem
extends ESBoss
implements RayAttackUser {
    private final ESServerBossEvent bossEvent = new ESServerBossEvent(this, this.method_5667(), class_1259.class_1260.field_5780, false);
    private final BehaviorManager<StarlightGolem> behaviorManager = new BehaviorManager<StarlightGolem>(this, List.of(new StarlightGolemLaserBeamPhase(), new StarlightGolemSummonFlamePhase(), new StarlightGolemSmashPhase(), new StarlightGolemChargeStartPhase(), new StarlightGolemChargePhase(), new StarlightGolemChargeEndPhase()));
    public class_7094 laserBeamAnimationState = new class_7094();
    public class_7094 summonFlameAnimationState = new class_7094();
    public class_7094 smashAnimationState = new class_7094();
    public class_7094 chargeStartAnimationState = new class_7094();
    public class_7094 chargeAnimationState = new class_7094();
    public class_7094 chargeEndAnimationState = new class_7094();
    public class_7094 deathAnimationState = new class_7094();
    private int attackEnergy;
    private int chargeHurtCount;
    private float chargeHurtAmount;
    private int lastHurtSound;

    public StarlightGolem(class_1299<? extends StarlightGolem> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void clearChargeHurtCountAndAmount() {
        this.chargeHurtCount = 0;
        this.chargeHurtAmount = 0.0f;
    }

    public int getChargeHurtCount() {
        return this.chargeHurtCount;
    }

    public float getChargeHurtAmount() {
        return this.chargeHurtAmount;
    }

    public int getAttackEnergy() {
        return this.attackEnergy;
    }

    public void setAttackEnergy(int energy) {
        this.attackEnergy = energy;
    }

    public boolean canHurt() {
        return this.getNearbyEnergyBlocks(true).isEmpty();
    }

    @Override
    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.bossEvent.setId(this.method_5667());
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new GolemLookAtTargetGoal());
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{StarlightGolem.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    @Override
    public boolean isRayFollowingHeadRotation() {
        return false;
    }

    @Override
    public class_243 getRayRotationTarget() {
        return this.method_5968() == null ? this.method_19538().method_1031((double)(this.method_17681() * (this.method_59922().method_43057() - 0.5f)), (double)(this.method_17682() * this.method_59922().method_43057()), (double)(this.method_17681() * (this.method_59922().method_43057() - 0.5f))) : this.method_5968().method_19538().method_1031(0.0, (double)(this.method_5968().method_17682() / 2.0f), 0.0);
    }

    @Override
    public void updateRayEnd(class_243 endPos) {
        this.method_5702(class_2183.class_2184.field_9851, endPos);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.starlightGolem.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.starlightGolem.armor()).method_26868(class_5134.field_23717, ESConfig.INSTANCE.mobsConfig.starlightGolem.followRange()).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23721, 0.0).method_26868(class_5134.field_23718, 1.0);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (!source.method_48789(class_8103.field_42242)) {
            if (this.canHurt() && this.getBehaviorState() == 5 && !source.method_49708(class_8111.field_42345) && !source.method_49708(class_8111.field_42354) && source.method_5529() != this) {
                if (source.method_5529() != null) {
                    ++this.chargeHurtCount;
                    this.chargeHurtAmount += amount;
                }
            } else {
                if (source.method_5526() instanceof class_1309 && this.field_6012 - this.lastHurtSound > 20) {
                    this.method_5783(ESSoundEvents.STARLIGHT_GOLEM_BLOCK.get(), this.method_6107(), this.method_6017());
                    this.lastHurtSound = this.field_6012;
                }
                return false;
            }
        }
        return super.method_5643(source, amount);
    }

    protected void method_6108() {
        if (this.field_6213 == 0) {
            this.stopAllAnimStates();
            this.deathAnimationState.method_41322(this.field_6012);
            this.setBehaviorState(0);
        }
        ++this.field_6213;
        if (this.field_6213 == 110 && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void stopAllAnimStates() {
        this.laserBeamAnimationState.method_41325();
        this.summonFlameAnimationState.method_41325();
        this.smashAnimationState.method_41325();
        this.chargeStartAnimationState.method_41325();
        this.chargeAnimationState.method_41325();
        this.chargeEndAnimationState.method_41325();
    }

    public void method_5674(class_2940<?> accessor) {
        if (accessor.equals((Object)BEHAVIOR_STATE) && this.getBehaviorState() != 0) {
            this.stopAllAnimStates();
            switch (this.getBehaviorState()) {
                case 1: {
                    this.laserBeamAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 2: {
                    this.summonFlameAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 3: {
                    this.smashAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 4: {
                    this.chargeStartAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 5: {
                    this.chargeAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 6: {
                    this.chargeEndAnimationState.method_41322(this.field_6012);
                }
            }
        }
        super.method_5674(accessor);
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5722(class_1297 entity) {
        return super.method_5722(entity) || entity.method_5864().method_20210(ESTags.EntityTypes.STARLIGHT_GOLEM_ALLYS);
    }

    @Override
    public boolean canBossMove() {
        return false;
    }

    private List<class_2338> getNearbyEnergyBlocks(boolean lit) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_4153 poiManager = serverLevel.method_19494();
            return poiManager.method_30957(poi -> poi.method_40225(ESPoiTypes.ENERGY_BLOCK.getResourceKey()), pos -> {
                class_2680 state = serverLevel.method_8320(pos);
                return !lit || state.method_28498((class_2769)EnergyBlock.LIT) && (Boolean)state.method_11654((class_2769)EnergyBlock.LIT) != false;
            }, this.method_24515(), 48, class_4153.class_4155.field_18489).limit(5L).map(Pair::getSecond).toList();
        }
        return List.of();
    }

    public void turnOnEnergyBlocks() {
        List<class_2338> list = this.getNearbyEnergyBlocks(false);
        for (class_2338 pos : list) {
            class_2680 state = this.method_37908().method_8320(pos);
            if (!state.method_27852((class_2248)ESBlocks.ENERGY_BLOCK.get()) || ((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) continue;
            this.method_37908().method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)));
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            class_243 center = pos.method_46558();
            ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(RingExplosionParticleOptions.ENERGY, center.method_10216(), center.method_10214(), center.method_10215(), 0.0, 0.2, 0.0));
        }
    }

    public void spawnEnergizedFlame(int maxNum, int scanRadius, boolean trackTarget) {
        int left = maxNum;
        if (trackTarget) {
            EnergizedFlame energizedFlame = (EnergizedFlame)ESEntities.ENERGIZED_FLAME.get().method_5883(this.method_37908());
            energizedFlame.method_33574(this.method_5968() != null ? this.method_5968().method_19538() : this.method_19538());
            energizedFlame.setOwner((class_1309)this);
            this.method_37908().method_8649((class_1297)energizedFlame);
            --left;
        }
        ArrayList<class_2338> possiblePositions = new ArrayList<class_2338>();
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                for (int y = -5; y <= 5; ++y) {
                    class_2338 firePos = this.method_24515().method_10069(x, y, z);
                    if (!this.method_37908().method_22347(firePos) || !this.method_37908().method_8320(firePos.method_10074()).method_26206((class_1922)this.method_37908(), firePos.method_10074(), class_2350.field_11036)) continue;
                    possiblePositions.add(firePos);
                }
            }
        }
        for (int i = 0; i < left; ++i) {
            if (possiblePositions.isEmpty()) continue;
            class_2338 firePos = (class_2338)possiblePositions.get(this.method_59922().method_43048(possiblePositions.size()));
            EnergizedFlame energizedFlame = (EnergizedFlame)ESEntities.ENERGIZED_FLAME.get().method_5883(this.method_37908());
            energizedFlame.method_33574(firePos.method_46558().method_1031(0.0, -0.5, 0.0));
            energizedFlame.setOwner((class_1309)this);
            this.method_37908().method_8649((class_1297)energizedFlame);
            possiblePositions.remove(firePos);
        }
    }

    public void method_6007() {
        super.method_6007();
        this.bossEvent.update();
        if (!this.method_37908().field_9236) {
            if (this.method_5968() != null && !this.method_5968().method_5805()) {
                this.method_5980(null);
            }
            if (!this.method_5987() && this.method_5805()) {
                this.behaviorManager.tick();
            }
            List<class_2338> list = this.getNearbyEnergyBlocks(true);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                if (this.getBehaviorState() == 5 && !list.isEmpty()) {
                    for (class_2338 pos : list) {
                        class_243 angle = this.method_19538().method_1031((double)(-pos.method_10263()) - 0.5, (double)(-pos.method_10264()) - 1.0, (double)(-pos.method_10260()) - 0.5);
                        double px = (double)pos.method_10263() + 0.5;
                        double py = (double)pos.method_10264() + 1.0;
                        double pz = (double)pos.method_10260() + 0.5;
                        for (int i = 0; i < 10; ++i) {
                            double dx = angle.method_10216();
                            double dy = angle.method_10214();
                            double dz = angle.method_10215();
                            double spread = 5.0 + (double)this.method_59922().method_43057() * 2.5;
                            double velocity = (3.0 + (double)this.method_59922().method_43057() * 0.15) / 45.0;
                            dx += this.method_59922().method_43059() * 0.0075 * spread;
                            dy += this.method_59922().method_43059() * 0.0075 * spread;
                            dz += this.method_59922().method_43059() * 0.0075 * spread;
                            ESPlatform.INSTANCE.sendToTrackingClients(serverLevel, (class_1297)this, new ParticlePacket((class_2394)ESParticles.ENERGY.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity));
                        }
                    }
                }
            }
        } else if (this.method_59922().method_43048(15) == 0) {
            class_243 smokePos = this.method_19538().method_1031((double)(this.method_17681() * (this.method_59922().method_43057() - 0.5f)), (double)(this.method_17682() * this.method_59922().method_43057()), (double)(this.method_17681() * (this.method_59922().method_43057() - 0.5f)));
            this.method_37908().method_8406((class_2394)class_2398.field_17430, smokePos.field_1352, smokePos.field_1351, smokePos.field_1350, (double)(this.method_59922().method_43057() - 0.5f) * 0.15, (double)this.method_59922().method_43057() * 0.15, (double)(this.method_59922().method_43057() - 0.5f) * 0.15);
        }
    }

    @Override
    public void dropExtraLoot(class_3222 player) {
        ESCrestUtil.upgradeCrest((class_1657)player, ESCrests.BLAZING_BEAM);
    }

    @Override
    public class_3414 getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS_STARLIGHT_GOLEM.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return ESSoundEvents.STARLIGHT_GOLEM_HURT.get();
    }

    protected class_3414 method_6002() {
        return ESSoundEvents.STARLIGHT_GOLEM_DEATH.get();
    }

    private class GolemLookAtTargetGoal
    extends LookAtTargetGoal {
        public GolemLookAtTargetGoal() {
            super((class_1308)StarlightGolem.this);
        }

        @Override
        public void method_6268() {
            boolean affectsLook;
            boolean bl = affectsLook = StarlightGolem.this.getBehaviorState() == 1;
            if (!affectsLook) {
                super.method_6268();
            }
        }
    }
}

