/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Stranghoul;
import cn.leolezury.eternalstarlight.common.item.interfaces.Swingable;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESAttributes;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.util.ESAccessoryUtil;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4051;
import net.minecraft.class_4174;
import net.minecraft.class_5131;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Shadow
    @Nullable
    protected class_1799 field_51570;
    @Shadow
    private Optional<class_2338> field_22418;

    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    @Shadow
    public abstract boolean method_6115();

    @Shadow
    public abstract class_1799 method_6030();

    @Shadow
    public abstract Collection<class_1293> method_6026();

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    public abstract boolean method_6016(class_6880<class_1291> var1);

    @Shadow
    @NotNull
    public abstract class_1799 method_59958();

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract class_5131 method_6127();

    @Shadow
    @Nullable
    public abstract class_1309 method_6124();

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")})
    private void swing(class_1268 interactionHand, boolean bl, CallbackInfo ci) {
        class_1792 class_17922 = this.method_5998(interactionHand).method_7909();
        if (class_17922 instanceof Swingable) {
            Swingable swingable = (Swingable)class_17922;
            swingable.swing(this.method_5998(interactionHand), (class_1309)this, interactionHand);
        }
    }

    @Inject(method={"isBlocking"}, at={@At(value="RETURN")}, cancellable=true)
    private void isBlocking(CallbackInfoReturnable<Boolean> cir) {
        if (this.method_6115() && this.method_6030().method_31573(ESTags.Items.GREATSWORDS)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getKnockback"}, at={@At(value="RETURN")}, cancellable=true)
    private void getKnockback(class_1297 target, class_1282 damageSource, CallbackInfoReturnable<Float> cir) {
        if (this.method_59958().method_31573(ESTags.Items.HAMMERS)) {
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() + 1.0f));
        }
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void createLivingAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(ESAttributes.THROWN_POTION_DISTANCE.asHolder()).method_26867(ESAttributes.ETHER_RESISTANCE.asHolder()).method_26867(ESAttributes.FIRE_RESISTANCE.asHolder()).method_26867(ESAttributes.METEOR_COUNTERATTACK_CHANCE.asHolder()).method_26867(ESAttributes.HEAL_MULTIPLIER.asHolder());
    }

    @Inject(method={"checkAutoSpinAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", shift=At.Shift.AFTER)})
    private void checkAutoSpinAttack(CallbackInfo ci) {
        this.doCrescentSpearDamage();
    }

    @Inject(method={"checkAutoSpinAttack"}, at={@At(value="HEAD")})
    private void checkAutoSpinAttackTail(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity.field_5976) {
            this.doCrescentSpearDamage();
        }
    }

    @Unique
    private void doCrescentSpearDamage() {
        class_1309 entity = (class_1309)this;
        if (this.field_51570 != null && this.field_51570.method_31574(ESItems.CRESCENT_SPEAR.get())) {
            if (!entity.method_37908().field_9236) {
                class_1937 living2;
                for (class_1937 living2 : entity.method_37908().method_18466(class_1309.class, class_4051.field_18092, entity, entity.method_5829().method_1014(3.0))) {
                    if (!ESEntityUtil.shouldHarm((class_1297)entity, (class_1297)living2) || !(entity instanceof class_1657)) continue;
                    class_1657 player = (class_1657)entity;
                    player.field_6273 = class_3532.method_15386((float)player.method_7279());
                    player.method_7324((class_1297)living2);
                    class_1937 class_19372 = entity.method_37908();
                    if (!(class_19372 instanceof class_3218)) continue;
                    class_3218 serverLevel = (class_3218)class_19372;
                    class_243 targetPos = living2.method_19538().method_1031((entity.method_59922().method_43058() - 0.5) * (double)living2.method_17681(), entity.method_59922().method_43058() * (double)living2.method_17682(), (entity.method_59922().method_43058() - 0.5) * (double)living2.method_17681());
                    class_243 speed = targetPos.method_1020(entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0));
                    class_243 pos = targetPos.method_1020(speed.method_1029().method_1021(1.0));
                    for (int i = 0; i < 2; ++i) {
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((class_2394)ESParticles.LUNAR_SLASH.get(), pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350));
                    }
                }
                living2 = entity.method_37908();
                if (living2 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)living2;
                    class_243 centerPos = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0);
                    for (int i = 0; i < 10; ++i) {
                        class_243 speed = new class_243((double)((entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.1f), (double)(entity.method_59922().method_43057() * 0.05f), (double)((entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.1f)).method_1029();
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.CRESCENT_SPEAR, centerPos.field_1352 + speed.field_1352 * 1.5, centerPos.field_1351 + speed.field_1351 * 1.5, centerPos.field_1350 + speed.field_1350 * 1.5, speed.field_1352, speed.field_1351, speed.field_1350));
                    }
                    ScreenShakeVfx.createInstance((class_5321<class_1937>)entity.method_37908().method_27983(), entity.method_19538(), 40.0f, 20, 0.12f, 0.24f, 3.0f, 5.5f).send(serverLevel);
                }
                entity.field_6008 = Math.max(entity.field_6008, 10);
            }
            ESDataAttachments.CRESCENT_SPEAR_DASH.setData((class_1297)entity, false);
        }
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")})
    private void eat(class_1937 level, class_1799 itemStack, class_4174 foodProperties, CallbackInfoReturnable<class_1799> cir) {
        if (itemStack.method_31574(ESItems.LUNARIS_CACTUS_GEL.get())) {
            ArrayList<class_6880> effectsToRemove = new ArrayList<class_6880>();
            for (class_1293 effectInstance : this.method_6026()) {
                if (((class_1291)effectInstance.method_5579().comp_349()).method_5573()) continue;
                effectsToRemove.add(effectInstance.method_5579());
            }
            for (class_6880 effect : effectsToRemove) {
                if (!this.method_6059((class_6880<class_1291>)effect)) continue;
                this.method_6016((class_6880<class_1291>)effect);
            }
        } else if (itemStack.method_31574(ESItems.PUNGENCY_STEW.get())) {
            this.method_6016((class_6880<class_1291>)class_1294.field_5903);
        }
    }

    @WrapOperation(method={"triggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseAnimation()Lnet/minecraft/world/item/UseAnim;")})
    private class_1839 getUseAnimation(class_1799 instance, Operation<class_1839> original) {
        if (ESAccessoryUtil.getActiveAccessoriesOnArmors((class_1309)this).contains(ESItems.FUNGUS_AMULET.get()) && instance.method_31573(ESTags.Items.CONSUMABLE_WHEN_WEARING_FUNGUS_AMULET)) {
            return class_1839.field_8950;
        }
        return (class_1839)original.call(new Object[]{instance});
    }

    @Inject(method={"onClimbable"}, at={@At(value="RETURN")}, cancellable=true)
    private void onClimbable(CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity = (class_1309)this;
        if (this.method_6059(ESMobEffects.STICKY.asHolder())) {
            boolean climbable = false;
            class_238 box = livingEntity.method_5829();
            class_2338 fromPos = class_2338.method_49637((double)(box.field_1323 - 0.001), (double)(box.field_1322 + 1.0E-7), (double)(box.field_1321 - 0.001));
            class_2338 toPos = class_2338.method_49637((double)(box.field_1320 + 0.001), (double)(box.field_1325 - 1.0E-7), (double)(box.field_1324 + 0.001));
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (int i = fromPos.method_10263(); i <= toPos.method_10263(); ++i) {
                for (int j = fromPos.method_10264(); j <= toPos.method_10264(); ++j) {
                    for (int k = fromPos.method_10260(); k <= toPos.method_10260(); ++k) {
                        mutableBlockPos.method_10103(i, j, k);
                        if (!livingEntity.method_37908().method_8320((class_2338)mutableBlockPos).method_26234((class_1922)livingEntity.method_37908(), (class_2338)mutableBlockPos)) continue;
                        climbable = true;
                    }
                }
            }
            if (climbable) {
                this.field_22418 = Optional.of(livingEntity.method_24515());
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;updateGlowingStatus()V", shift=At.Shift.AFTER)})
    private void tickEffects(CallbackInfo ci) {
        float damage;
        class_1309 livingEntity = (class_1309)this;
        if (!this.method_6059(ESMobEffects.NUMBNESS.asHolder()) && (damage = ESDataAttachments.NUMBNESS_DAMAGE.getData((class_1297)livingEntity).floatValue()) != 0.0f) {
            livingEntity.method_5643(ESDamageTypes.getDamageSource(livingEntity.method_37908(), ESDamageTypes.NUMBNESS), damage);
            ESDataAttachments.NUMBNESS_DAMAGE.setData((class_1297)livingEntity, Float.valueOf(0.0f));
        }
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;gameEvent(Lnet/minecraft/core/Holder;)V", shift=At.Shift.AFTER)})
    private void die(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        if (livingEntity.method_5864().method_20210(ESTags.EntityTypes.STRANGHOUL_PREYS) && this.method_6124() instanceof Stranghoul) {
            List players = livingEntity.method_37908().method_18464(class_4051.method_36626(), livingEntity, livingEntity.method_5829().method_1014(20.0));
            for (class_1657 player : players) {
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                ESCriteriaTriggers.WITNESS_STRANGHOUL_HUNT.get().method_9141(serverPlayer);
            }
        }
    }
}

