/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.OrbitalTrailParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class ESCrestUtil {
    public static List<Crest.Instance> getCrests(class_1657 player) {
        return ESDataAttachments.CRESTS.getData((class_1297)player);
    }

    public static List<Crest.Instance> getOwnedCrests(class_1657 player) {
        return ESDataAttachments.OWNED_CRESTS.getData((class_1297)player);
    }

    public static void setCrests(class_1657 player, List<Crest.Instance> crests) {
        ESDataAttachments.CRESTS.setData((class_1297)player, crests);
    }

    public static void setOwnedCrests(class_1657 player, List<Crest.Instance> crests) {
        ESDataAttachments.OWNED_CRESTS.setData((class_1297)player, crests);
    }

    public static boolean giveCrest(class_1657 player, Crest.Instance crest) {
        List<Crest.Instance> set = ESCrestUtil.getOwnedCrests(player);
        ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>(set);
        for (Crest.Instance instance : crests) {
            if (!instance.crest().method_55838(crest.crest()) || instance.level() < crest.level()) continue;
            return false;
        }
        crests.removeIf(c -> c.crest().method_55838(crest.crest()));
        crests.add(crest);
        ESCrestUtil.setOwnedCrests(player, crests);
        return true;
    }

    public static boolean upgradeCrest(class_1657 player, class_5321<Crest> key) {
        int maxLevel = 0;
        Optional holder = player.method_56673().method_30530(ESRegistries.CREST).method_40264(key);
        if (holder.isPresent()) {
            maxLevel = ((Crest)((class_6880.class_6883)holder.get()).comp_349()).maxLevel();
        }
        if (ESCrestUtil.getCrestLevel(player, key) + 1 > maxLevel) {
            return false;
        }
        Optional<Crest.Instance> instance = Crest.Instance.of(player.method_56673(), key, ESCrestUtil.getCrestLevel(player, key) + 1);
        return instance.isPresent() && ESCrestUtil.giveCrest(player, instance.get());
    }

    public static boolean removeCrest(class_1657 player, class_6880<Crest> crest) {
        ESCrestUtil.removeCrest(player, crest, false);
        return ESCrestUtil.removeCrest(player, crest, true);
    }

    public static boolean removeCrest(class_1657 player, class_6880<Crest> crest, boolean owned) {
        List<Crest.Instance> set = owned ? ESCrestUtil.getOwnedCrests(player) : ESCrestUtil.getCrests(player);
        ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>(set);
        if (crests.stream().noneMatch(c -> c.crest().method_55838(crest))) {
            return false;
        }
        crests.removeIf(c -> c.crest().method_55838(crest));
        if (owned) {
            ESCrestUtil.setOwnedCrests(player, crests);
        } else {
            ESCrestUtil.setCrests(player, crests);
        }
        return true;
    }

    public static List<Crest.Instance> mergeCrests(List<Crest.Instance> first, List<Crest.Instance> second) {
        ArrayList<Crest.Instance> result = new ArrayList<Crest.Instance>(first);
        for (Crest.Instance instance : second) {
            boolean hasSame = false;
            int level = instance.level();
            for (int i = 0; i < result.size(); ++i) {
                if (!((Crest.Instance)result.get(i)).crest().method_55838(instance.crest())) continue;
                level = Math.max(level, ((Crest.Instance)result.get(i)).level());
                result.set(i, new Crest.Instance(instance.crest(), level));
                hasSame = true;
            }
            if (hasSame) continue;
            result.add(instance);
        }
        return result;
    }

    public static int getCrestLevel(class_1657 player, class_5321<Crest> key) {
        Optional crest = player.method_56673().method_30530(ESRegistries.CREST).method_40264(key);
        return crest.map(ref -> ESCrestUtil.getCrestLevel(player, (class_6880<Crest>)ref)).orElse(0);
    }

    public static int getCrestLevel(class_1657 player, class_6880<Crest> crest) {
        List<Crest.Instance> set = ESCrestUtil.getOwnedCrests(player);
        for (Crest.Instance instance : set) {
            if (!instance.crest().method_55838(crest)) continue;
            return instance.level();
        }
        return 0;
    }

    public static void tickCrests(class_1657 player) {
        class_1937 class_19372;
        class_6880 component;
        List<Crest.Instance> ownedSet = ESCrestUtil.getOwnedCrests(player);
        List<Crest.Instance> set = ESCrestUtil.getCrests(player);
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        if (mainHand.method_57826(ESDataComponents.CURRENT_CREST.get())) {
            component = (class_6880)mainHand.method_57824(ESDataComponents.CURRENT_CREST.get());
            if (component != null && component.method_40227() && ownedSet.stream().noneMatch(c -> c.crest().method_55838(component))) {
                mainHand.method_57381(ESDataComponents.CURRENT_CREST.get());
            }
        } else if (offHand.method_57826(ESDataComponents.CURRENT_CREST.get()) && (component = (class_6880)offHand.method_57824(ESDataComponents.CURRENT_CREST.get())) != null && component.method_40227() && ownedSet.stream().noneMatch(c -> c.crest().method_55838(component))) {
            offHand.method_57381(ESDataComponents.CURRENT_CREST.get());
        }
        ArrayList oldActiveCrests = new ArrayList(ESDataAttachments.OLD_ACTIVE_CRESTS.getData((class_1297)player));
        ArrayList activeCrests = new ArrayList();
        set.forEach(crest -> {
            boolean doEffects = false;
            if (player.method_56992()) {
                doEffects = true;
            } else {
                class_1661 inventory = player.method_31548();
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 stack = inventory.method_5438(i);
                    if (!stack.method_31573(((Crest)crest.crest().comp_349()).type().getCrystalsTag())) continue;
                    doEffects = true;
                    if (player.field_6012 % 60 != 0) break;
                    stack.method_7970(crest.level(), (class_1309)player, class_1304.field_6173);
                    break;
                }
            }
            if (doEffects) {
                activeCrests.add(crest);
                ((Crest)crest.crest().comp_349()).effects().ifPresent(effects -> effects.forEach(mobEffect -> player.method_6092(new class_1293(mobEffect.effect(), 20, mobEffect.level() + (crest.level() - 1) * mobEffect.levelAddition()))));
                ((Crest)crest.crest().comp_349()).attributeModifiers().ifPresent(modifiers -> modifiers.forEach(modifier -> {
                    class_1324 instance = player.method_6127().method_45329(modifier.attribute());
                    if (instance != null && !instance.method_6196(modifier.id())) {
                        instance.method_26837(modifier.getModifier(crest.level()));
                    }
                }));
            }
        });
        oldActiveCrests.removeAll(activeCrests);
        for (Crest.Instance crest2 : oldActiveCrests) {
            ((Crest)crest2.crest().comp_349()).attributeModifiers().ifPresent(modifiers -> modifiers.forEach(modifier -> {
                class_1324 instance = player.method_6127().method_45329(modifier.attribute());
                if (instance != null && instance.method_6196(modifier.id())) {
                    instance.method_6200(modifier.id());
                }
            }));
        }
        ESDataAttachments.OLD_ACTIVE_CRESTS.setData((class_1297)player, activeCrests);
        if (!set.isEmpty() && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (player.field_6012 % 100 == 0) {
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(OrbitalTrailParticleOptions.magic(player), player.method_23317(), player.method_23318(), player.method_23321(), 0.0, 0.02, 0.0));
            }
        }
    }
}

