/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.util.Easing;
import java.util.ArrayList;
import java.util.List;

public record SmoothSegmentedValue(List<Segment> segments) {
    public static SmoothSegmentedValue of(Easing easing, float from, float to, float size) {
        return new SmoothSegmentedValue(new ArrayList<Segment>(List.of(new Segment(easing, from, to, size))));
    }

    public static SmoothSegmentedValue constant(float value) {
        return new SmoothSegmentedValue(List.of(new Segment(v -> v, value, value, 1.0f)));
    }

    public SmoothSegmentedValue add(Easing easing, float from, float to, float size) {
        this.segments().add(new Segment(easing, from, to, size));
        return this;
    }

    public float calculate(float progress) {
        float accumulatedSize = 0.0f;
        for (Segment segment : this.segments()) {
            if (!((accumulatedSize += segment.size()) >= progress)) continue;
            return segment.easing().interpolate(1.0f - (accumulatedSize - progress) / segment.size(), segment.from(), segment.to());
        }
        return this.segments().isEmpty() ? 0.0f : this.segments().getLast().to();
    }

    public record Segment(Easing easing, float from, float to, float size) {
    }
}

