/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.biomesource;

import cn.leolezury.eternalstarlight.common.world.gen.biomesource.IESBiomeSource;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldArea;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldGenProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceFunction;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

public class ESBiomeSource
extends class_1966
implements IESBiomeSource {
    public static final MapCodec<ESBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldGenProvider.CODEC.fieldOf("worldgen_provider").forGetter(o -> o.provider), (App)class_6895.method_40340((class_5321)class_7924.field_41236).fieldOf("biomes").forGetter(o -> o.biomeHolderSet)).apply((Applicative)instance, instance.stable(ESBiomeSource::new)));
    private final WorldGenProvider provider;
    private final class_6885<class_1959> biomeHolderSet;

    public ESBiomeSource(WorldGenProvider provider, class_6885<class_1959> biomeHolderSet) {
        this.provider = provider;
        this.biomeHolderSet = biomeHolderSet;
    }

    public void setSeed(long seed) {
        this.provider.setSeed(seed);
    }

    public void setRegistryAccess(class_5455 access) {
        this.provider.setRegistryAccess(access);
    }

    public void setCacheSize(int size) {
        this.provider.setCacheSize(size);
    }

    protected MapCodec<? extends class_1966> method_28442() {
        return CODEC;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return this.biomeHolderSet.method_40239();
    }

    @Override
    public BiomeData getBiomeData(int x, int z) {
        return this.provider.getWorldArea(x, z).getBiomeData(x, z);
    }

    @Override
    public int getBiome(int x, int z) {
        return this.provider.getWorldArea(x, z).getBiome(x, z);
    }

    @Override
    public int getHeight(int x, int z) {
        return this.provider.getWorldArea(x, z).getHeight(x, z);
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        return this.provider.getBiomeDataById(this.getBiome(x * 4, z * 4)).biome();
    }

    public Cached cache() {
        return new Cached();
    }

    public class Cached
    extends class_1966
    implements IESBiomeSource {
        private final Long2ReferenceArrayMap<WorldArea> cachedAreas = new Long2ReferenceArrayMap();
        private final Long2ReferenceFunction<WorldArea> getWorldAreaUncachedFunction = this::getWorldAreaUncached;

        private WorldArea getWorldArea(int x, int z) {
            int areaX = x >> 10;
            int areaZ = z >> 10;
            long areaPos = class_1923.method_8331((int)areaX, (int)areaZ);
            return (WorldArea)this.cachedAreas.computeIfAbsent(areaPos, this.getWorldAreaUncachedFunction);
        }

        private WorldArea getWorldAreaUncached(long pos) {
            int x = class_1923.method_8325((long)pos);
            int z = class_1923.method_8332((long)pos);
            return ESBiomeSource.this.provider.getWorldArea(x << 10, z << 10);
        }

        protected MapCodec<? extends class_1966> method_28442() {
            return ESBiomeSource.this.method_28442();
        }

        protected Stream<class_6880<class_1959>> method_49494() {
            return ESBiomeSource.this.method_49494();
        }

        public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
            return ESBiomeSource.this.provider.getBiomeDataById(this.getBiome(x * 4, z * 4)).biome();
        }

        @Override
        public BiomeData getBiomeData(int x, int z) {
            return this.getWorldArea(x, z).getBiomeData(x, z);
        }

        @Override
        public int getBiome(int x, int z) {
            return this.getWorldArea(x, z).getBiome(x, z);
        }

        @Override
        public int getHeight(int x, int z) {
            return this.getWorldArea(x, z).getHeight(x, z);
        }
    }
}

