/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;

public class JinglestemFeature
extends class_3031<Configuration> {
    private static final List<class_2350> ATTACHMENT_FACES = List.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034);

    public JinglestemFeature(Codec<Configuration> codec) {
        super(codec);
    }

    private void placeBlockLine(class_2338 from, class_2338 to, Consumer<class_2338> placer) {
        List<int[]> points = ESMathUtil.getBresenham3DPoints(from.method_10263(), from.method_10264(), from.method_10260(), to.method_10263(), to.method_10264(), to.method_10260());
        for (int[] point : points) {
            class_2338 trunkPos = new class_2338(point[0], point[1], point[2]);
            placer.accept(trunkPos);
        }
    }

    private void placeBranches(class_2338 pos, int num, int len, Consumer<class_2338> placer) {
        for (int i = 0; i < num; ++i) {
            class_243 endVec = ESMathUtil.rotationToPosition(pos.method_46558(), len, 40.0f, 360.0f / (float)num * (float)i);
            class_2338 endPos = new class_2338((int)endVec.field_1352, (int)endVec.field_1351, (int)endVec.field_1350);
            this.placeBlockLine(pos, endPos, placer);
        }
    }

    public boolean method_13151(class_5821<Configuration> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        class_5819 random = context.method_33654();
        ArrayList trunkPositions = new ArrayList();
        Configuration config = (Configuration)context.method_33656();
        class_2680 attachmentState = (class_2680)ESBlocks.ALGALEAVES.get().method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        int height = config.trunkHeight().method_35008(random);
        class_2338 topPos = pos.method_10069(random.method_43048(5) - 2, height, random.method_43048(5) - 2);
        this.placeBlockLine(pos, topPos, trunkPositions::add);
        int num = config.branchAmount().method_35008(random);
        int len = config.branchLength().method_35008(random);
        this.placeBranches(topPos, num, len, trunkPositions::add);
        for (class_2338 blockPos : trunkPositions) {
            if (level.method_8320(blockPos).method_27852(class_2246.field_10382)) continue;
            return false;
        }
        for (class_2338 blockPos : trunkPositions) {
            this.method_13153((class_1945)level, blockPos, ESBlocks.JINGLESTEM_LOG.get().method_9564());
        }
        if (config.hasLeaves()) {
            for (class_2338 blockPos : trunkPositions) {
                if (random.method_43048(10) != 0) {
                    int l = config.leavesHeight().method_35008(random);
                    for (int i = 1; i <= l; ++i) {
                        if (level.method_8320(blockPos.method_10087(i)).method_27852(class_2246.field_10382)) {
                            this.method_13153((class_1945)level, blockPos.method_10087(i), ESBlocks.HANGING_ALGALEAVES_PLANT.get().method_9564());
                            if (i != l) continue;
                            this.method_13153((class_1945)level, blockPos.method_10087(i), ESBlocks.HANGING_ALGALEAVES.get().method_9564());
                            continue;
                        }
                        if (i == 1) break;
                        this.method_13153((class_1945)level, blockPos.method_10087(i - 1), ESBlocks.HANGING_ALGALEAVES.get().method_9564());
                        break;
                    }
                }
                float chance = 1.25f * (float)(blockPos.method_10264() - pos.method_10264()) / (float)height;
                if (!(random.method_43057() < chance)) continue;
                for (class_2350 attachDir : ATTACHMENT_FACES) {
                    class_2338 placePos = blockPos.method_10093(attachDir);
                    if (!level.method_8320(placePos).method_27852(class_2246.field_10382)) continue;
                    ArrayList<class_2350> possibleDirs = new ArrayList<class_2350>();
                    for (class_2350 direction2 : class_2350.values()) {
                        class_2338 relativePos = placePos.method_10093(direction2);
                        if (!level.method_8320(relativePos).method_27852((class_2248)ESBlocks.JINGLESTEM_LOG.get())) continue;
                        possibleDirs.add(direction2);
                    }
                    for (class_2350 direction2 : class_2350.values()) {
                        attachmentState = possibleDirs.contains(direction2) ? (class_2680)attachmentState.method_11657((class_2769)class_2429.field_11329.get(direction2), (Comparable)Boolean.valueOf(random.method_43056())) : (class_2680)attachmentState.method_11657((class_2769)class_2429.field_11329.get(direction2), (Comparable)Boolean.valueOf(false));
                    }
                    class_2680 finalAttachmentState = attachmentState;
                    if (!Arrays.stream(class_2350.values()).anyMatch(direction -> (Boolean)finalAttachmentState.method_11654((class_2769)class_2429.field_11329.get(direction)))) continue;
                    this.method_13153((class_1945)level, placePos, finalAttachmentState);
                }
            }
        }
        return true;
    }

    public record Configuration(class_6017 trunkHeight, class_6017 branchAmount, class_6017 branchLength, class_6017 leavesHeight, boolean hasLeaves) implements class_3037
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6017.field_29946.fieldOf("trunk_height").forGetter(Configuration::trunkHeight), (App)class_6017.field_29946.fieldOf("branch_amount").forGetter(Configuration::branchAmount), (App)class_6017.field_29946.fieldOf("branch_length").forGetter(Configuration::branchLength), (App)class_6017.field_29946.fieldOf("leaves_height").forGetter(Configuration::leavesHeight), (App)Codec.BOOL.fieldOf("has_leaves").forGetter(Configuration::hasLeaves)).apply((Applicative)instance, Configuration::new));
    }
}

