/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.block.model.DogBedItemOverride;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DogBedModel
implements BakedModel {
    public static DogBedItemOverride ITEM_OVERIDE = new DogBedItemOverride();
    private static final ResourceLocation MISSING_TEXTURE = Util.getVanillaResource("missingno");
    private final ModelBakery modelLoader;
    private final BlockModel unbakedModel;
    private final BakedModel defaultModelVariant;
    private final Map<Direction, BakedModel> defaultModelVariants = new ConcurrentHashMap<Direction, BakedModel>(Direction.values().length);
    private final Map<Direction, BakedModel> missingModelVariant = new ConcurrentHashMap<Direction, BakedModel>(Direction.values().length);
    private static final Map<Triple<ICasingMaterial, IBeddingMaterial, Direction>, BakedModel> cache = Maps.newConcurrentMap();
    private final int maxCacheSize;

    public DogBedModel(ModelBakery modelLoader, BlockModel model, BakedModel defaultModelVariant, int maxCacheSize) {
        this.modelLoader = modelLoader;
        this.unbakedModel = model;
        this.defaultModelVariant = defaultModelVariant;
        this.maxCacheSize = maxCacheSize;
    }

    public static void clearCache() {
        cache.clear();
    }

    public BakedModel getModelVariant(@Nonnull ModelData data) {
        return this.getModelVariant((ICasingMaterial)data.get(DogBedTileEntity.CASING), (IBeddingMaterial)data.get(DogBedTileEntity.BEDDING), (Direction)data.get(DogBedTileEntity.FACING));
    }

    public BakedModel getModelVariant(ICasingMaterial casing, IBeddingMaterial bedding, Direction facing) {
        if (facing == null) {
            facing = Direction.NORTH;
        }
        if (casing == null || bedding == null) {
            return this.getDefaultVariant(facing);
        }
        if (casing.isNani() || bedding.isNani()) {
            return this.getMissingVariant(facing);
        }
        ImmutableTriple key = ImmutableTriple.of((Object)casing, (Object)bedding, (Object)facing);
        BakedModel model_variant = cache.get(key);
        if (model_variant != null) {
            return model_variant;
        }
        if (cache.size() >= this.maxCacheSize) {
            return this.getDefaultVariant(facing);
        }
        model_variant = this.bakeModelVariant(casing, bedding, facing);
        cache.put((Triple<ICasingMaterial, IBeddingMaterial, Direction>)key, model_variant);
        return model_variant;
    }

    private BakedModel getMissingVariant(Direction dir) {
        BakedModel missing = this.missingModelVariant.get(dir);
        if (missing != null) {
            return missing;
        }
        missing = this.bakeModelVariant(DogBedMaterialManager.NaniCasing.NULL, DogBedMaterialManager.NaniBedding.NULL, dir);
        this.missingModelVariant.put(dir, missing);
        return missing;
    }

    private BakedModel getDefaultVariant(Direction dir) {
        BakedModel default_variant = this.defaultModelVariants.get(dir);
        if (default_variant != null) {
            return default_variant;
        }
        default_variant = DogBedModel.bakeModel(this.unbakedModel, dir);
        this.defaultModelVariants.put(dir, default_variant);
        return default_variant;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand) {
        return this.getModelVariant(null, null, Direction.NORTH).getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    public List<BakedQuad> getQuads(@javax.annotation.Nullable BlockState state, @javax.annotation.Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @javax.annotation.Nullable RenderType renderType) {
        return this.getModelVariant(data).getQuads(state, side, rand, ModelData.EMPTY, renderType);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        return this.getModelVariant(data).getParticleIcon(data);
    }

    public BakedModel bakeModelVariant(@javax.annotation.Nullable ICasingMaterial casing, @javax.annotation.Nullable IBeddingMaterial bedding, @Nonnull Direction facing) {
        BlockModel new_model = DogBedModel.deepCopyBlockModel(this.unbakedModel);
        Either<Material, String> casing_texture = DogBedModel.findCasingTexture(casing);
        Either<Material, String> bedding_texture = DogBedModel.findBeddingTexture(bedding);
        new_model.textureMap.put("bedding", bedding_texture);
        new_model.textureMap.put("casing", casing_texture);
        new_model.textureMap.put("particle", casing_texture);
        BakedModel ret = DogBedModel.bakeModel(new_model, facing);
        return ret;
    }

    private static BlockModel deepCopyBlockModel(BlockModel model) {
        List elements_old = model.getElements();
        ArrayList<BlockElement> elements_new = new ArrayList<BlockElement>(elements_old.size());
        for (BlockElement element : elements_old) {
            BlockElement element_copy = new BlockElement(element.from, element.to, (Map)Maps.newHashMap((Map)element.faces), element.rotation, element.shade);
            elements_new.add(element_copy);
        }
        BlockModel ret = new BlockModel(model.getParentLocation(), elements_new, (Map)Maps.newHashMap((Map)model.textureMap), Boolean.valueOf(model.hasAmbientOcclusion()), model.getGuiLight(), model.getTransforms(), new ArrayList(model.getOverrides()));
        ret.name = model.name;
        ret.parent = model.parent;
        return ret;
    }

    private static BakedModel bakeModel(final BlockModel to_bake, final Direction dir) {
        var baker = new ModelBaker(){

            @javax.annotation.Nullable
            public BakedModel bake(ResourceLocation location, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
                return to_bake.bake((ModelBaker)this, to_bake, Material::sprite, (ModelState)DogBedModel.getModelRotation(dir), true);
            }

            public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
                return Material::sprite;
            }

            public UnbakedModel getModel(ResourceLocation p_252194_) {
                return to_bake;
            }

            @javax.annotation.Nullable
            public BakedModel bake(ResourceLocation p_250776_, ModelState p_251280_) {
                return this.bake(p_250776_, p_251280_, this.getModelTextureGetter());
            }

            @Nullable
            public UnbakedModel getTopLevelModel(ModelResourceLocation location) {
                return null;
            }

            @Nullable
            public BakedModel bakeUncached(UnbakedModel model, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
                return null;
            }
        };
        return baker.bake(null, null, null);
    }

    private static BlockModelRotation getModelRotation(@Nonnull Direction dir) {
        switch (dir) {
            default: {
                return BlockModelRotation.X0_Y0;
            }
            case EAST: {
                return BlockModelRotation.X0_Y90;
            }
            case SOUTH: {
                return BlockModelRotation.X0_Y180;
            }
            case WEST: 
        }
        return BlockModelRotation.X0_Y270;
    }

    private static Either<Material, String> findCasingTexture(@javax.annotation.Nullable ICasingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<Material, String> findBeddingTexture(@javax.annotation.Nullable IBeddingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<Material, String> findTexture(ResourceLocation resource) {
        if (resource == null) {
            resource = MISSING_TEXTURE;
        }
        return Either.left((Object)new Material(InventoryMenu.BLOCK_ATLAS, resource));
    }

    public boolean useAmbientOcclusion() {
        return this.defaultModelVariant.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.defaultModelVariant.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.defaultModelVariant.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.defaultModelVariant.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.defaultModelVariant.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.defaultModelVariant.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return ITEM_OVERIDE;
    }
}

