/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import org.apache.commons.lang3.tuple.Pair;

public class DogWolfArmorRenderer
extends RenderLayer<Dog, DogModel> {
    private static final Map<Crackiness.Level, ResourceLocation> ARMOR_CRACK_LOCATIONS = Map.of(Crackiness.Level.LOW, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_low.png"), Crackiness.Level.MEDIUM, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_medium.png"), Crackiness.Level.HIGH, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_high.png"));
    private DogModel defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();

    public DogWolfArmorRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (!dog.isTame() || dog.isInvisible()) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.RENDER_ARMOR.get()).booleanValue() || dog.hideArmor()) {
            return;
        }
        DogSkin skin = dog.getClientSkin();
        if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        if (dog.wolfArmor().isEmpty()) {
            return;
        }
        Optional<Pair<ItemStack, AnimalArmorItem>> wolfArmorOptional = this.getWolfArmorItem(dog);
        if (!wolfArmorOptional.isPresent()) {
            return;
        }
        Pair<ItemStack, AnimalArmorItem> wolfArmorPair = wolfArmorOptional.get();
        DogModel parentModel = (DogModel)this.getParentModel();
        DogModel dogModel = parentModel.useDefaultModelForAccessories() ? this.defaultModel : parentModel;
        if (dogModel != parentModel) {
            ((DogModel)this.getParentModel()).copyPropertiesTo(dogModel);
            dogModel.copyFrom(parentModel);
        }
        this.renderWolfArmorLayerMain(dogModel, poseStack, buffer, packedLight, (AnimalArmorItem)wolfArmorPair.getRight());
        this.renderWolfArmorLayerDyed(dogModel, poseStack, buffer, packedLight, (ItemStack)wolfArmorPair.getLeft(), (AnimalArmorItem)wolfArmorPair.getRight());
        this.renderWolfArmorLayerCracks(dogModel, poseStack, buffer, packedLight, (ItemStack)wolfArmorPair.getLeft());
    }

    private Optional<Pair<ItemStack, AnimalArmorItem>> getWolfArmorItem(Dog dog) {
        ItemStack wolf_armor_stack = dog.wolfArmor();
        Item item = wolf_armor_stack.getItem();
        if (!(item instanceof AnimalArmorItem)) {
            return Optional.empty();
        }
        AnimalArmorItem wolfArmorItem = (AnimalArmorItem)item;
        if (wolfArmorItem.getBodyType() != AnimalArmorItem.BodyType.CANINE) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)wolf_armor_stack, (Object)wolfArmorItem));
    }

    private void renderWolfArmorLayerMain(DogModel model, PoseStack poseStack, MultiBufferSource buffer, int light, AnimalArmorItem item) {
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)item.getTexture()));
        model.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
    }

    private void renderWolfArmorLayerDyed(DogModel model, PoseStack stack, MultiBufferSource buffer, int light, ItemStack itemStack, AnimalArmorItem item) {
        if (item != Items.WOLF_ARMOR) {
            return;
        }
        int i = DyedItemColor.getOrDefault((ItemStack)itemStack, (int)0);
        if (FastColor.ARGB32.alpha((int)i) == 0) {
            return;
        }
        ResourceLocation armor_overlay = item.getOverlayTexture();
        if (armor_overlay == null) {
            return;
        }
        float r = (float)FastColor.ARGB32.red((int)i) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)i) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)i) / 255.0f;
        model.renderToBuffer(stack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)armor_overlay)), light, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)r, (float)g, (float)b));
    }

    private void renderWolfArmorLayerCracks(DogModel model, PoseStack stack, MultiBufferSource buffer, int light, ItemStack itemStack) {
        Crackiness.Level crack_level = Crackiness.WOLF_ARMOR.byDamage(itemStack);
        if (crack_level == Crackiness.Level.NONE) {
            return;
        }
        ResourceLocation crack_rl = ARMOR_CRACK_LOCATIONS.get(crack_level);
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)crack_rl));
        model.renderToBuffer(stack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, -1);
    }
}

