/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTags;
import doggytalents.common.util.TagUtil;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class DTEntityTagsProvider
extends EntityTypeTagsProvider {
    public DTEntityTagsProvider(PackOutput p_256095_, CompletableFuture<HolderLookup.Provider> p_256572_, @Nullable ExistingFileHelper existingFileHelper) {
        super(p_256095_, p_256572_, "doggytalents", existingFileHelper);
    }

    public String getName() {
        return "DoggyTalents Entity Tags";
    }

    public void addTags(HolderLookup.Provider provider) {
        this.createTag(DoggyTags.DOG_SHOULD_IGNORE, () -> EntityType.ENDERMAN);
        this.createTag(DoggyTags.DROP_SOY_WHEN_DOG_KILL, () -> EntityType.CREEPER, () -> EntityType.ZOMBIE, () -> EntityType.SKELETON, () -> EntityType.SPIDER);
        this.createTag(DoggyTags.MOB_RETRIEVER_MUST_IGNORE, () -> EntityType.CREEPER);
        this.createTag(EntityTypeTags.IMPACT_PROJECTILES, DoggyEntityTypes.DOG_ARROW_PROJ, DoggyEntityTypes.DOG_TRIDENT_PROJ);
        this.createTag(EntityTypeTags.ARROWS, DoggyEntityTypes.DOG_ARROW_PROJ);
        this.createTag(TagUtil.CAPTURING_NOT_SUPPORTED, DoggyEntityTypes.DOG);
    }

    @SafeVarargs
    private final void createTag(TagKey<EntityType<?>> tag, Supplier<? extends EntityType<?>> ... entities) {
        this.tag(tag).add((Object[])((EntityType[])Arrays.stream(entities).map(Supplier::get).toArray(EntityType[]::new)));
    }
}

