/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ObjectUtils;

public class DogHurtByTargetGoal
extends HurtByTargetGoal {
    private final Dog dog;

    public DogHurtByTargetGoal(Dog dog) {
        super((PathfinderMob)dog, new Class[0]);
        this.dog = dog;
        this.setAlertOthers(new Class[0]);
    }

    public boolean canUse() {
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        return super.canUse();
    }

    protected void alertOthers() {
        LivingEntity target = this.dog.getLastHurtByMob();
        if (target == null) {
            return;
        }
        LivingEntity owner = this.dog.getOwner();
        if (owner == null) {
            return;
        }
        double alert_radius = this.getFollowDistance();
        AABB alert_bb = AABB.unitCubeFromLowerCorner((Vec3)this.dog.position()).inflate(alert_radius, 10.0, alert_radius);
        List alert_dogs = this.dog.level().getEntitiesOfClass(Dog.class, alert_bb, filter_dog -> this.isDogAlertTarget((Dog)filter_dog, target, owner));
        if (alert_dogs.isEmpty()) {
            return;
        }
        for (Dog alert_dog : alert_dogs) {
            this.alertOther((Mob)alert_dog, target);
        }
    }

    private boolean isDogAlertTarget(Dog other_dog, LivingEntity target, LivingEntity owner) {
        if (other_dog == this.dog) {
            return false;
        }
        UUID other_owner_id = other_dog.getOwnerUUID();
        if (other_owner_id == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)owner.getUUID(), (Object)other_owner_id)) {
            return false;
        }
        if (other_dog.getTarget() != null) {
            return false;
        }
        return other_dog.wantsToAttack(target, owner);
    }

    public void start() {
        super.start();
        this.targetMob = null;
    }
}

