/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyEntityTypes;
import doggytalents.common.entity.misc.SamoyedPlushie;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SamoyedPlushieItem
extends Item {
    public SamoyedPlushieItem(Item.Properties itemProps) {
        super(itemProps.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState state = level.getBlockState(pos);
        BlockPos spawnAt = state.getCollisionShape((BlockGetter)level, pos).isEmpty() ? pos : pos.relative(face);
        SamoyedPlushie plush = (SamoyedPlushie)DoggyEntityTypes.SAMOYED_PLUSHIE_TOY.get().create((ServerLevel)level, null, spawnAt, MobSpawnType.TRIGGERED, !Objects.equals(pos, spawnAt) && face == Direction.UP, false);
        if (plush != null) {
            plush.setYRot(face.getOpposite().toYRot());
            level.addFreshEntity((Entity)plush);
        }
        if (player != null && !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (player != null) {
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        if (context.level() == null) {
            return;
        }
        String desc_id = "items.doggytalents.piano_item_common.description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
    }
}

