/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGoAndCarryPlayerAction;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.CarryMeData;
import doggytalents.common.talent.WolfMountTalent;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public class CarryMePacket
extends DogPacket<CarryMeData> {
    @Override
    public CarryMeData decode(FriendlyByteBuf buf) {
        return new CarryMeData(buf.readInt());
    }

    @Override
    public void handleDog(Dog dog, CarryMeData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer owner = ctx.get().getSender();
        if (!dog.canInteract((LivingEntity)owner)) {
            return;
        }
        if (owner.getCooldowns().isOnCooldown((Item)DoggyItems.WHISTLE.get())) {
            return;
        }
        if (!((Boolean)ConfigHandler.SERVER.CARRY_ME_WHISTLE.get()).booleanValue()) {
            return;
        }
        if (owner.distanceToSqr((Entity)dog) > 144.0) {
            return;
        }
        if (!WolfMountTalent.isValidCarryMeDog(dog)) {
            return;
        }
        if (!WolfMountTalent.isValidCarryMeTarget((LivingEntity)owner)) {
            return;
        }
        dog.clearTriggerableAction();
        dog.triggerAction(new DogGoAndCarryPlayerAction(dog, (LivingEntity)owner));
        owner.level().playSound(null, owner.blockPosition(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + owner.level().random.nextFloat() * 0.1f, 0.4f + owner.level().random.nextFloat() * 0.2f);
        owner.sendSystemMessage((Component)Component.translatable((String)"dogcommand.carry_me", (Object[])new Object[]{dog.getName().getString()}));
        owner.getCooldowns().addCooldown((Item)DoggyItems.WHISTLE.get(), 20);
    }
}

