/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogMigrateOwnerData;
import doggytalents.common.util.ItemUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DogMigrateOwnerPacket
extends DogPacket<DogMigrateOwnerData> {
    @Override
    public void encode(DogMigrateOwnerData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.confirmed);
    }

    @Override
    public DogMigrateOwnerData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        boolean confirmed = buf.readBoolean();
        return new DogMigrateOwnerData(id, confirmed);
    }

    @Override
    public void handleDog(Dog dog, DogMigrateOwnerData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        ItemStack stack = sender.getMainHandItem();
        if (stack.getItem() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (sender.getCooldowns().isOnCooldown(DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.getOwnerUUID();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.getUUID())) {
            return;
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        if (tag == null) {
            return;
        }
        if (!tag.hasUUID("request_uuid")) {
            ItemUtil.modifyTag(stack, to_modify -> to_modify.remove("request_str"));
            return;
        }
        UUID uuid = tag.getUUID("request_uuid");
        ItemUtil.modifyTag(stack, to_modify -> {
            to_modify.remove("request_uuid");
            to_modify.remove("request_str");
        });
        if (ownerUUID.equals(uuid)) {
            return;
        }
        Player requester = dog.level().getPlayerByUUID(uuid);
        if (requester == null) {
            return;
        }
        if (!data.confirmed) {
            requester.sendSystemMessage((Component)Component.translatable((String)"item.doggytalents.amnesia_bone.migrate_owner.reject", (Object[])new Object[]{dog.getName().getString()}).withStyle(ChatFormatting.RED));
            return;
        }
        if (sender.experienceLevel < AmnesiaBoneItem.getMigrateOwnerXPCost()) {
            return;
        }
        dog.migrateOwner(uuid);
        sender.giveExperienceLevels(-AmnesiaBoneItem.getMigrateOwnerXPCost());
        sender.getCooldowns().addCooldown(DoggyItems.AMNESIA_BONE.get(), 60);
        int usedTime = tag.getInt("amnesia_bone_used_time");
        if (++usedTime >= AmnesiaBoneItem.getUseCap()) {
            stack.shrink(1);
            sender.onEquippedItemBroken(stack.getItem(), EquipmentSlot.MAINHAND);
        }
        tag.putInt("amnesia_bone_used_time", usedTime);
        requester.sendSystemMessage((Component)Component.translatable((String)"item.doggytalents.amnesia_bone.migrate_owner.confirmed", (Object[])new Object[]{dog.getName().getString(), dog.getGenderPronoun()}));
        ItemUtil.putTag(stack, tag);
    }
}

