/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.TalentInstance;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;

public class Talent {
    @Nullable
    private String translationKey;
    @Nullable
    private String translationInfoKey;
    @Nullable
    private final BiFunction<Talent, Integer, TalentInstance> create;

    public Talent(BiFunction<Talent, Integer, TalentInstance> sup) {
        this.create = sup;
    }

    public int getMaxLevel() {
        return 5;
    }

    public int getLevelCost(int toGoToLevel) {
        return toGoToLevel;
    }

    public int getCummulativeCost(int level) {
        return level * (level + 1) / 2;
    }

    public int getDeTrainXPCost(int level) {
        return level < this.getMaxLevel() ? 1 : 2;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.m_137492_((String)"talent", (ResourceLocation)DoggyTalentsAPI.TALENTS.get().getKey((Object)this));
        }
        return this.translationKey;
    }

    public String getInfoTranslationKey() {
        if (this.translationInfoKey == null) {
            this.translationInfoKey = this.getTranslationKey() + ".description";
        }
        return this.translationInfoKey;
    }

    public TalentInstance getDefault(int level) {
        if (this.create == null) {
            return new TalentInstance(this, level);
        }
        return this.create.apply(this, level);
    }

    public TalentInstance getDefault() {
        return this.getDefault(1);
    }

    public boolean isDogEligible(AbstractDog dog) {
        return true;
    }

    public Optional<String> getNonEligibleTranslationKey(AbstractDog dog) {
        return Optional.empty();
    }

    public boolean hasRenderer() {
        return false;
    }
}

