/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.block.tileentity.FoodBowlTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.container.DogArmorContainer;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.DoggyToolsMenu;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.TreatBagContainer;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;

public class Screens {
    public static void openPackPuppyScreen(ServerPlayer player, Dog dogIn) {
        if (!dogIn.canInteract((LivingEntity)player)) {
            return;
        }
        if (dogIn.isDoingFine()) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new PackPuppyContainerProvider(dogIn), buf -> buf.writeInt(dogIn.m_19879_()));
        }
    }

    public static void openDogInventoriesScreen(ServerPlayer player, List<Dog> dogIn) {
        if (!dogIn.isEmpty()) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new DogInventoriesContainerProvider(dogIn), buf -> {
                buf.writeInt(dogIn.size());
                for (Dog dog : dogIn) {
                    buf.writeInt(dog.m_19879_());
                }
            });
        }
    }

    public static void openFoodBowlScreen(ServerPlayer player, FoodBowlTileEntity foodBowl) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)foodBowl, (BlockPos)foodBowl.m_58899_());
    }

    public static void openTreatBagScreen(ServerPlayer player, ItemStack stackIn, int slotId) {
        if (stackIn.m_41720_() == DoggyItems.TREAT_BAG.get()) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new TreatBagContainerProvider(stackIn, slotId), buf -> {
                buf.m_130130_(slotId);
                buf.m_130055_(stackIn);
            });
        }
    }

    public static void openArmorScreen(ServerPlayer player, Dog dogIn) {
        if (!dogIn.canInteract((LivingEntity)player)) {
            return;
        }
        if (dogIn.isDoingFine() && dogIn.getDogLevel((Supplier)DoggyTalents.DOGGY_ARMOR) > 0) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new DogArmorContainerProvider(dogIn), buf -> buf.writeInt(dogIn.m_19879_()));
        }
    }

    public static void openDoggyToolsScreen(ServerPlayer player, Dog dogIn) {
        if (!dogIn.canInteract((LivingEntity)player)) {
            return;
        }
        if (dogIn.isDoingFine() && dogIn.getDogLevel((Supplier)DoggyTalents.DOGGY_TOOLS) > 0) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new DoggyToolsMenuProvider(dogIn), buf -> buf.writeInt(dogIn.m_19879_()));
        }
    }

    public static class PackPuppyContainerProvider
    implements MenuProvider {
        private AbstractDog dog;

        public PackPuppyContainerProvider(AbstractDog dogIn) {
            this.dog = dogIn;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return new PackPuppyContainer(windowId, inventory, this.dog);
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"container.doggytalents.pack_puppy");
        }
    }

    public static class DogInventoriesContainerProvider
    implements MenuProvider {
        private List<Dog> dogs;

        public DogInventoriesContainerProvider(List<Dog> dogIn) {
            this.dogs = dogIn;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return new DogInventoriesContainer(windowId, inventory, this.dogs);
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"container.doggytalents.dog_inventories");
        }
    }

    public static class TreatBagContainerProvider
    implements MenuProvider {
        private ItemStack stack;
        private int slotId;

        public TreatBagContainerProvider(ItemStack stackIn, int slotId) {
            this.stack = stackIn;
            this.slotId = slotId;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return new TreatBagContainer(windowId, inventory, this.slotId, this.stack);
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"container.doggytalents.treat_bag");
        }
    }

    public static class DogArmorContainerProvider
    implements MenuProvider {
        private Dog dog;

        public DogArmorContainerProvider(Dog dog) {
            this.dog = dog;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return new DogArmorContainer(windowId, inventory, this.dog);
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"container.doggytalents.dog_armor");
        }
    }

    public static class DoggyToolsMenuProvider
    implements MenuProvider {
        private Dog dog;

        public DoggyToolsMenuProvider(Dog dog) {
            this.dog = dog;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return new DoggyToolsMenu(windowId, inventory, this.dog);
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"container.doggytalents.doggy_tools");
        }
    }
}

