/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.client.entity.sound.DogInterruptibleSoundInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogInterruptibleSoundData;
import java.lang.ref.WeakReference;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public class DogSoundManager {
    private final Dog dog;
    private boolean ambientVoiceLock = false;
    private final DogInterruptibleSoundInstanceRef interruptListener = new DogInterruptibleSoundInstanceRef();

    public DogSoundManager(Dog dog) {
        this.dog = dog;
    }

    public void setAmbientLocked(boolean val) {
        this.ambientVoiceLock = val;
    }

    public boolean isAmbientLocked() {
        return this.ambientVoiceLock;
    }

    public void tick() {
    }

    public void playInterruptible(SoundEvent event, float volume, float pitch) {
        if (this.dog.m_20067_()) {
            return;
        }
        DogInterruptibleSoundData data = new DogInterruptibleSoundData(this.dog.m_19879_(), Optional.of(event), volume, pitch);
        if (this.dog.m_9236_().f_46443_) {
            this.onDogInterruptableSoundUpdate(data);
        } else {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.dog), data);
        }
    }

    public void playNonInterruptible(SoundEvent event, float volume, float pitch) {
        if (this.dog.m_20067_()) {
            return;
        }
        if (this.dog.m_9236_().f_46443_) {
            return;
        }
        this.dog.m_9236_().m_6269_(null, (Entity)this.dog, event, SoundSource.AMBIENT, volume, pitch);
    }

    public void interuptPlaying() {
        DogInterruptibleSoundData data = DogInterruptibleSoundData.stop(this.dog.m_19879_());
        if (this.dog.m_9236_().f_46443_) {
            this.onDogInterruptableSoundUpdate(data);
        } else {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.dog), data);
        }
    }

    public void onDogInterruptableSoundUpdate(DogInterruptibleSoundData data) {
        DogInterruptibleSoundInstance clientSound = this.interruptListener.getOrNull();
        if (clientSound != null) {
            clientSound.dogInterupt();
        }
        if (!data.sound().isPresent()) {
            this.interruptListener.resetRef();
            return;
        }
        clientSound = DogInterruptibleSoundInstance.createAndPlayClient(this.dog, data.sound().get(), data.volume(), data.pitch());
        this.interruptListener.setRef(clientSound);
    }

    private static class DogInterruptibleSoundInstanceRef {
        private WeakReference<DogInterruptibleSoundInstance> ref = null;

        public DogInterruptibleSoundInstance getOrNull() {
            if (this.ref == null) {
                return null;
            }
            DogInterruptibleSoundInstance inst = (DogInterruptibleSoundInstance)((Object)this.ref.get());
            if (inst == null) {
                this.resetRef();
            }
            return inst;
        }

        public void setRef(DogInterruptibleSoundInstance inst) {
            this.ref = inst != null ? new WeakReference<DogInterruptibleSoundInstance>(inst) : null;
        }

        public void resetRef() {
            this.setRef(null);
        }
    }
}

