/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogSwimMoveControl;
import doggytalents.common.entity.ai.nav.DogWaterBoundNavigation;
import doggytalents.common.util.EntityUtil;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraftforge.common.ForgeMod;

public class DogSwimmingManager {
    private final Dog dog;
    private static final UUID SWIM_BOOST_ID = UUID.fromString("50671e42-1ded-4f97-9e2b-78bbeb1e8772");
    private DogSwimMoveControl moveControl_water;
    private DogWaterBoundNavigation navigator_water;
    private boolean swimming = false;
    private static final float baseSwimSpeedModifierAdd = 2.0f;
    public static final float swimSpeedModifierAddCap = 10.0f;
    private float swimSpeedModifierAdd = 2.0f;

    public DogSwimmingManager(Dog dog) {
        this.dog = dog;
    }

    public void tickServer() {
        if (!this.dog.canSwimUnderwater()) {
            return;
        }
        if (this.moveControl_water == null || this.navigator_water == null) {
            return;
        }
        if (this.swimming) {
            this.updateSwimming(this.dog);
        } else {
            this.updateNotSwimming(this.dog);
        }
    }

    public void onPropsUpdated(DogAlterationProps props) {
        if (this.swimming) {
            this.swimming = false;
            this.stopSwimming(this.dog);
        }
        if (props.canSwimUnderwater()) {
            this.moveControl_water = new DogSwimMoveControl(this.dog);
            this.navigator_water = new DogWaterBoundNavigation(this.dog, this.dog.m_9236_());
            this.swimSpeedModifierAdd = 2.0f + Mth.m_14036_((float)props.bonusSwimSpeed(), (float)0.0f, (float)10.0f);
        } else {
            this.moveControl_water = null;
            this.navigator_water = null;
        }
    }

    private void updateSwimming(Dog dog) {
        if (!dog.m_20069_() && dog.m_20096_() || !dog.m_20160_() && dog.isLowAirSupply() || dog.isDefeated() || this.hasNonControllingNonWaterBreathingPassenger(dog)) {
            this.swimming = false;
            this.stopSwimming(dog);
        }
    }

    private void updateNotSwimming(Dog dog) {
        if (dog.m_20069_() && !dog.isDefeated() && this.readyToBeginSwimming(dog) && !this.hasNonControllingNonWaterBreathingPassenger(dog) && !dog.isDogSwimming()) {
            this.swimming = true;
            this.startSwimming(dog);
        }
    }

    private boolean readyToBeginSwimming(Dog dog) {
        return dog.m_20146_() == dog.m_6062_();
    }

    private boolean hasNonControllingNonWaterBreathingPassenger(Dog dog) {
        if (!dog.m_20160_()) {
            return false;
        }
        if (dog.m_217005_()) {
            return false;
        }
        Entity passenger = dog.m_146895_();
        if (passenger == null) {
            return false;
        }
        if (!(passenger instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)passenger;
        return !EntityUtil.isWaterBreathingEntity(living);
    }

    private void applySwimAttributes(Dog dog) {
        dog.setAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_BOOST_ID, (dd, u) -> new AttributeModifier(u, "Swim Boost", (double)this.swimSpeedModifierAdd, AttributeModifier.Operation.ADDITION));
    }

    private void removeSwimAttributes(Dog dog) {
        dog.removeAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_BOOST_ID);
    }

    private void startSwimming(Dog dog) {
        dog.m_6862_(false);
        dog.setNavigation((PathNavigation)this.navigator_water);
        dog.setMoveControl(this.moveControl_water);
        if (dog.m_21825_()) {
            dog.m_21837_(false);
        }
        this.applySwimAttributes(dog);
        dog.setDogSwimming(true);
    }

    private void stopSwimming(Dog dog) {
        dog.resetMoveControl();
        dog.resetNavigation();
        this.removeSwimAttributes(dog);
        dog.setDogSwimming(false);
    }
}

