/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.DogGreedyFireSafeSearchPath;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DogGoAwayFromFireGoal
extends Goal {
    private Dog dog;
    private int tickUntilSearch;
    private int lastGoAwayTimestamp;
    private int walkableUntilStop = 1;
    private DogGreedyFireSafeSearchPath path;

    public DogGoAwayFromFireGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.dog.m_5825_()) {
            return false;
        }
        if (this.dog.shouldDogNotAfraidOfFire()) {
            return false;
        }
        int dangerSpot = -1;
        if (--this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 3;
            dangerSpot = this.isDogInDangerSpot(this.dog.m_20182_());
        }
        if (dangerSpot == -1) {
            return false;
        }
        this.path = DogGreedyFireSafeSearchPath.create(this.dog, 10);
        if (this.path == null || !this.checkCanReplaceCurrentPath(this.dog, this.path)) {
            this.tickUntilSearch = 5;
            this.path = null;
            return false;
        }
        return true;
    }

    private boolean checkCanReplaceCurrentPath(Dog dog, DogGreedyFireSafeSearchPath new_path) {
        Path current_path = this.dog.m_21573_().m_26570_();
        if (current_path == null) {
            return true;
        }
        if (current_path.m_77392_()) {
            return true;
        }
        Node current_next_node = current_path.m_77401_();
        float current_next_malus = dog.m_21439_(current_next_node.f_77282_);
        float new_next_malus = dog.m_21439_(new_path.m_77375_((int)0).f_77282_);
        return new_next_malus < current_next_malus;
    }

    public boolean m_8045_() {
        boolean is_safe;
        if (this.path == null) {
            return false;
        }
        if (this.dog.m_21573_().m_26571_()) {
            return false;
        }
        boolean bl = is_safe = this.path.getWalkableCount() >= this.walkableUntilStop && this.checkAboveForFallingLava(this.dog.m_20183_());
        return !is_safe;
    }

    public void m_8056_() {
        if (this.path == null) {
            return;
        }
        PathNavigation nav = this.dog.m_21573_();
        nav.m_26573_();
        nav.m_26536_((Path)this.path, (double)this.dog.getUrgentSpeedModifier());
        BlockPos b0 = this.path.m_77375_(0).m_77288_();
        DogUtil.stopAndForceLook(this.dog, b0.m_252807_());
        this.dog.m_21566_().m_6849_((double)((float)b0.m_123341_() + 0.5f), (double)b0.m_123342_(), (double)((float)b0.m_123343_() + 0.5f), (double)this.dog.getUrgentSpeedModifier());
        this.dog.setDogForcePushAvoid(true);
        int tick_since_last = this.dog.f_19797_ - this.lastGoAwayTimestamp;
        this.walkableUntilStop = tick_since_last >= 20 ? 1 : 2;
    }

    public void m_8041_() {
        this.dog.setDogForcePushAvoid(false);
        this.tickUntilSearch = 5;
        this.lastGoAwayTimestamp = this.dog.f_19797_;
        this.proccessEndNode();
        this.dog.m_21573_().m_26573_();
    }

    private void proccessEndNode() {
        if (this.path == null) {
            return;
        }
        Node end_node = this.path.m_77395_();
        if (end_node == null) {
            return;
        }
        BlockPos b0 = end_node.m_77288_();
        this.dog.m_21566_().m_6849_((double)((float)b0.m_123341_() + 0.5f), (double)b0.m_123342_(), (double)((float)b0.m_123343_() + 0.5f), (double)this.dog.getUrgentSpeedModifier());
        if (end_node.f_77282_ != BlockPathTypes.WALKABLE) {
            this.tickUntilSearch = 20 + this.dog.m_217043_().m_188503_(3) * 10;
        }
    }

    private byte isDogInDangerSpot(Vec3 pos) {
        double FLUID_BB_DEFLATE = 0.001;
        double half_bbw = 0.5 * (double)this.dog.m_20205_() - 0.001;
        int min_x = Mth.m_14107_((double)(pos.f_82479_ - half_bbw)) - 1;
        int min_y = Mth.m_14107_((double)pos.f_82480_);
        int min_z = Mth.m_14107_((double)(pos.f_82481_ - half_bbw)) - 1;
        int max_x = Mth.m_14107_((double)(pos.f_82479_ + half_bbw)) + 1;
        int max_y = Mth.m_14107_((double)(pos.f_82480_ + 1.0));
        int max_z = Mth.m_14107_((double)(pos.f_82481_ + half_bbw)) + 1;
        byte ret = -1;
        for (BlockPos check_pos : BlockPos.m_121976_((int)min_x, (int)min_y, (int)min_z, (int)max_x, (int)max_y, (int)max_z)) {
            boolean is_corner;
            boolean bl = is_corner = !(check_pos.m_123341_() != min_x && check_pos.m_123341_() != max_x || check_pos.m_123343_() != min_z && check_pos.m_123343_() != max_z);
            if (is_corner) continue;
            AABB dog_bb = this.dog.m_20191_();
            boolean above_outside = check_pos.m_123342_() > min_y && !dog_bb.m_82381_(new AABB(new BlockPos(check_pos.m_123341_(), min_y, check_pos.m_123343_())));
            if (above_outside) continue;
            BlockState state = this.dog.m_9236_().m_8055_(check_pos);
            if (state.m_60819_().m_205070_(FluidTags.f_13132_)) {
                return 1;
            }
            AABB check_pos_bb = new AABB(check_pos);
            boolean pos_within_dog_bb = this.dog.m_20191_().m_82381_(check_pos_bb);
            if (!pos_within_dog_bb) continue;
            boolean is_burning = WalkNodeEvaluator.m_77622_((BlockState)state);
            if (is_burning) {
                return 1;
            }
            if (check_pos.m_123342_() != min_y) continue;
            BlockPos pos_below = DogUtil.getSurfaceStandingInPos(this.dog, check_pos.m_123341_(), check_pos.m_123343_()).m_7495_();
            BlockState state_below = this.dog.m_9236_().m_8055_(pos_below);
            boolean full_collision_burning_block = WalkNodeEvaluator.m_77622_((BlockState)state_below) && state_below.m_60838_((BlockGetter)this.dog.m_9236_(), pos_below);
            if (!full_collision_burning_block) continue;
            return 1;
        }
        return ret;
    }

    private boolean checkAboveForFallingLava(BlockPos pos) {
        BlockPos pos_above = pos.m_7494_();
        BlockState state_above = this.dog.m_9236_().m_8055_(pos_above);
        return !state_above.m_60713_(Blocks.f_49991_);
    }

    public boolean m_183429_() {
        return true;
    }
}

