/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DogWantAttentionAction
extends TriggerableAction {
    private Phase phase = Phase.GO_TO_OWNER;
    @Nonnull
    private final LivingEntity owner;
    private int goToOwnerTimeout;
    private int tickTillPathRecalc;
    private boolean whinedToAttention;
    private int tickAnim;
    private int stopTick;

    public DogWantAttentionAction(Dog dog, @Nonnull LivingEntity owner) {
        super(dog, true, false);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.tickTillPathRecalc = 5;
        this.phase = Phase.GO_TO_OWNER;
        this.goToOwnerTimeout = 200;
        this.whinedToAttention = false;
        this.tickAnim = 0;
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    @Override
    public void tick() {
        if (this.phase == Phase.GO_TO_OWNER) {
            if (this.goToOwnerTimeout <= 0) {
                this.stopAndMaySitDown();
                return;
            }
        } else {
            if (this.dog.f_19797_ >= this.stopTick) {
                this.stopAndMaySitDown();
                return;
            }
            if (this.dog.getAnim() != DogAnimation.PLAY_WITH_MEH) {
                this.stopAndMaySitDown();
                return;
            }
            if (this.dog.m_20280_((Entity)this.owner) > 16.0) {
                this.stopAndMaySitDown();
                return;
            }
        }
        if (this.phase == Phase.GO_TO_OWNER) {
            this.tickGoToOwner();
        } else {
            this.tickBegForAttention();
        }
    }

    private void stopAndMaySitDown() {
        this.setState(TriggerableAction.ActionState.FINISHED);
    }

    private void tickGoToOwner() {
        boolean closeEnough;
        this.dog.m_21563_().m_148051_((Entity)this.owner);
        if (--this.goToOwnerTimeout <= 0) {
            this.goToOwnerTimeout = 0;
            return;
        }
        double d0 = this.dog.m_20280_((Entity)this.owner);
        boolean bl = closeEnough = d0 <= 2.25;
        if (--this.tickTillPathRecalc <= 0) {
            if (!closeEnough) {
                this.dog.m_21573_().m_5624_((Entity)this.owner, 1.0);
            }
            this.tickTillPathRecalc = 20;
        }
        if (closeEnough) {
            if (!this.dog.m_21573_().m_26571_()) {
                this.dog.m_21573_().m_26573_();
            }
            if (!this.whinedToAttention) {
                this.whinedToAttention = true;
                SoundEvent sound = this.dog.dogMood.getWhineAttentionSound();
                this.dog.dogSoundManager.playInterruptible(sound, this.dog.m_6121_() + 0.2f, this.dog.m_6100_());
                int r = this.dog.m_217043_().m_188503_(3);
                this.owner.m_213846_((Component)Component.m_237110_((String)("dog.msg.want_attention." + r), (Object[])new Object[]{this.dog.m_7755_().getString()}));
            }
            this.checkAndSwitchToAttention();
        }
    }

    private void checkAndSwitchToAttention() {
        if (!DogUtil.checkIfOwnerIsLooking(this.dog, this.owner)) {
            return;
        }
        this.phase = Phase.BEG_FOR_ATTENTION;
        this.tickAnim = 0;
        this.stopTick = this.dog.f_19797_ + DogAnimation.PLAY_WITH_MEH.getLengthTicks();
        this.dog.setAnim(DogAnimation.PLAY_WITH_MEH);
    }

    private void tickBegForAttention() {
        this.dog.m_21563_().m_148051_((Entity)this.owner);
        ++this.tickAnim;
        if (this.tickAnim == 30) {
            SoundEvent sound = this.dog.dogMood.getJealousSound();
            this.dog.m_5496_(sound, this.dog.m_6121_(), this.dog.m_6100_());
        }
    }

    @Override
    public void onStop() {
        if (this.dog.getAnim() == DogAnimation.PLAY_WITH_MEH) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.dogSoundManager.interuptPlaying();
        this.dog.dogSoundManager.setAmbientLocked(false);
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }

    private static enum Phase {
        GO_TO_OWNER,
        BEG_FOR_ATTENTION;

    }
}

