/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyTalents;
import doggytalents.api.registry.Talent;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.DoggyToolsItemHandler;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class DoggyToolsMenu
extends AbstractContainerMenu {
    private Dog dog;
    private DoggyToolsItemHandler tools;
    private int beginToolsIndx = -1;
    private int toolsSize;

    public DoggyToolsMenu(int windowId, Inventory playerInventory, Dog dog) {
        super((MenuType)DoggyContainerTypes.DOG_TOOLS.get(), windowId);
        this.dog = dog;
        Optional<DoggyToolsTalent> talent = dog.getTalent((Supplier)DoggyTalents.DOGGY_TOOLS).map(inst -> inst.cast(DoggyToolsTalent.class));
        if (!talent.isPresent()) {
            return;
        }
        DoggyToolsItemHandler dogTools = talent.map(inst -> inst.getTools()).orElse(null);
        if (dogTools == null) {
            return;
        }
        this.tools = dogTools;
        for (int j = 0; j < 3; ++j) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)playerInventory, i1 + j * 9 + 9, 8 + i1 * 18, 45 + j * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 103));
        }
        this.beginToolsIndx = this.f_38839_.size();
        int mX = 90;
        int aY = 23;
        this.toolsSize = DoggyToolsTalent.getSize(talent.map(inst -> inst.level()).orElse(0));
        int toolsSlotsOffsetX = this.toolsSize / 2 * 18 + this.toolsSize % 2 * 9;
        int pX = mX - toolsSlotsOffsetX;
        for (int i = 0; i < this.toolsSize; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.tools, i, pX, aY));
            pX += 18;
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index >= this.beginToolsIndx ? !this.m_38903_(itemstack1, 0, this.beginToolsIndx, true) : !this.m_38903_(itemstack1, this.beginToolsIndx, this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        int toolsLevel = this.dog.getDogLevel((Talent)DoggyTalents.DOGGY_TOOLS.get());
        if (toolsLevel <= 0) {
            return false;
        }
        if (this.getToolsSize() != DoggyToolsTalent.getSize(toolsLevel)) {
            return false;
        }
        return this.dog.isDoingFine();
    }

    public int getToolsSize() {
        return this.toolsSize;
    }
}

