/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.FoodHandler;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.Screens;
import doggytalents.common.entity.misc.DogFoodProjectile;
import doggytalents.common.entity.misc.DogGunpowderProjectile;
import doggytalents.common.inventory.TreatBagItemHandler;
import doggytalents.common.util.Cache;
import doggytalents.common.util.DogFoodUtil;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TreatBagItem
extends Item
implements IDogFoodHandler {
    private Cache<String> contentsTranslationKey = Cache.make(() -> this.m_5524_() + ".contents");

    public TreatBagItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!playerIn.m_6144_()) {
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)playerIn;
                this.findFoodAndShootOut(sP, stack);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (playerIn instanceof ServerPlayer && !(playerIn instanceof FakePlayer)) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            Screens.openTreatBagScreen(serverPlayer, stack, playerIn.m_150109_().f_35977_);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void findFoodAndShootOut(ServerPlayer player, ItemStack stack) {
        TreatBagItemHandler itemHandler = new TreatBagItemHandler(stack);
        int foodStackId = this.findThrowableInItemHandler((IItemHandler)itemHandler);
        if (foodStackId < 0) {
            return;
        }
        ItemStack foodStack = itemHandler.getStackInSlot(foodStackId);
        if (foodStack.m_41619_()) {
            return;
        }
        if (foodStack.m_150930_(Items.f_42403_)) {
            this.throwGunpowder((Player)player);
        } else {
            this.throwFood((Player)player, foodStack.m_41720_());
        }
        foodStack = foodStack.m_41777_();
        foodStack.m_41774_(1);
        itemHandler.setStackInSlot(foodStackId, foodStack);
        player.m_36335_().m_41524_((Item)this, 20);
    }

    private void throwFood(Player player, Item item) {
        DogFoodProjectile dogFoodProj = new DogFoodProjectile(player.m_9236_(), (LivingEntity)player);
        dogFoodProj.setDogFoodStack(new ItemStack((ItemLike)item));
        dogFoodProj.m_5602_((Entity)player);
        dogFoodProj.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.8f, 1.0f);
        player.m_9236_().m_7967_((Entity)dogFoodProj);
    }

    private void throwGunpowder(Player player) {
        DogGunpowderProjectile dogGunpowderProj = new DogGunpowderProjectile(player.m_9236_(), (LivingEntity)player);
        dogGunpowderProj.m_5602_((Entity)player);
        dogGunpowderProj.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.8f, 1.0f);
        player.m_9236_().m_7967_((Entity)dogGunpowderProj);
    }

    private int findThrowableInItemHandler(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (FoodHandler.isFood(stack).isPresent()) {
                return i;
            }
            if (!stack.m_150930_(Items.f_42403_)) continue;
            return i;
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.doggytalents.treat_bag.help").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
        this.displayContents(stack, tooltip, flagIn);
    }

    private void displayContents(ItemStack stack, List<Component> tooltip, TooltipFlag flagIn) {
        TreatBagItemHandler inv = new TreatBagItemHandler(stack);
        ItemUtil.ContentOverview contentsOverview = ItemUtil.getContentOverview((IItemHandler)inv);
        Map<Item, Integer> contentsMap = contentsOverview.contents();
        if (contentsMap.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"item.doggytalents.treat_bag.contents"));
        for (Map.Entry<Item, Integer> entry : contentsMap.entrySet()) {
            MutableComponent c1 = Component.m_237110_((String)"item.doggytalents.starter_bundle.contains", (Object[])new Object[]{entry.getValue(), entry.getKey().m_41466_()}).m_130948_(Style.f_131099_.m_178520_(-6052957));
            tooltip.add((Component)c1);
        }
        if (contentsOverview.isMore() > 0) {
            tooltip.add((Component)Component.m_237110_((String)"item.doggytalents.treat_bag.contents.more", (Object[])new Object[]{contentsOverview.isMore()}).m_130948_(Style.f_131099_.m_178520_(-6052957)));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Override
    public boolean isFood(ItemStack stackIn) {
        return false;
    }

    @Override
    public boolean canConsume(AbstractDog dogIn, ItemStack stackIn, Entity entityIn) {
        if (dogIn.isDefeated()) {
            return false;
        }
        return entityIn instanceof LivingEntity ? dogIn.canInteract((LivingEntity)entityIn) : false;
    }

    @Override
    public InteractionResult consume(AbstractDog dogIn, ItemStack stackIn, Entity entityIn) {
        if (dogIn.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        TreatBagItemHandler treatBag = new TreatBagItemHandler(stackIn);
        return DogFoodUtil.tryFeedAny(dogIn, entityIn, (IItemHandlerModifiable)treatBag);
    }
}

