/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.CombatReturnStrategyData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class CombatReturnStrategyPacket
extends DogPacket<CombatReturnStrategyData> {
    @Override
    public void encode(CombatReturnStrategyData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeByte((int)data.val.getId());
    }

    @Override
    public CombatReturnStrategyData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        Dog.CombatReturnStrategy strategy = Dog.CombatReturnStrategy.fromId(buf.readByte());
        return new CombatReturnStrategyData(entityId, strategy);
    }

    @Override
    public void handleDog(Dog dog, CombatReturnStrategyData data, Supplier<NetworkEvent.Context> ctx) {
        if (!dog.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        dog.setCombatReturnStrategy(data.val);
    }
}

