/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByGroupData;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class HeelByGroupPackets {

    public static class REQUEST_HEEL
    implements IPacket<HeelByGroupData.REQUEST_HEEL> {
        @Override
        public void encode(HeelByGroupData.REQUEST_HEEL data, FriendlyByteBuf buf) {
            buf.writeBoolean(data.heelAndSit);
            DogGroupsManager.DogGroup group = data.group;
            buf.writeInt(group.color);
            buf.m_130072_(group.name, 16);
        }

        @Override
        public HeelByGroupData.REQUEST_HEEL decode(FriendlyByteBuf buf) {
            boolean heelAndSit = buf.readBoolean();
            int color = buf.readInt();
            String name = buf.m_130136_(16);
            return new HeelByGroupData.REQUEST_HEEL(new DogGroupsManager.DogGroup(name, color), heelAndSit);
        }

        @Override
        public void handle(HeelByGroupData.REQUEST_HEEL data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
                if (!side.isServer()) {
                    return;
                }
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.m_36335_().m_41519_((Item)DoggyItems.WHISTLE.get())) {
                    return;
                }
                List dogs = sender.m_9236_().m_6443_(Dog.class, sender.m_20191_().m_82377_(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.m_21830_((LivingEntity)sender) && dog.getGroups().isGroup(data.group));
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                if (max_heel_count > 0 && dogs.size() > max_heel_count) {
                    Collections.sort(dogs, new EntityUtil.Sorter((Entity)sender));
                    dogs = dogs.subList(0, max_heel_count);
                }
                for (Dog dog2 : dogs) {
                    if (dog2.m_20159_()) {
                        dog2.m_8127_();
                    }
                    dog2.clearTriggerableAction();
                    dog2.m_21839_(data.heelAndSit);
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch(sender.m_9236_(), dogs, (LivingEntity)sender, 3);
                sender.m_9236_().m_5594_(null, sender.m_20183_(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + sender.m_9236_().f_46441_.m_188501_() * 0.1f, 0.4f + sender.m_9236_().f_46441_.m_188501_() * 0.2f);
                sender.m_213846_((Component)Component.m_237110_((String)"dogcommand.heel_by_group", (Object[])new Object[]{Component.m_237113_((String)data.group.name).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(data.group.color))}));
                sender.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 40);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RESPONSE_GROUP_LIST
    implements IPacket<HeelByGroupData.RESPONSE_GROUP_LIST> {
        @Override
        public void encode(HeelByGroupData.RESPONSE_GROUP_LIST data, FriendlyByteBuf buf) {
            int size = data.groups.size();
            buf.writeInt(size);
            for (int i = 0; i < size; ++i) {
                DogGroupsManager.DogGroup group = data.groups.get(i);
                buf.writeInt(group.color);
                buf.m_130072_(group.name, 16);
            }
        }

        @Override
        public HeelByGroupData.RESPONSE_GROUP_LIST decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<DogGroupsManager.DogGroup> groups = new ArrayList<DogGroupsManager.DogGroup>(size);
            for (int i = 0; i < size; ++i) {
                int color = buf.readInt();
                String name = buf.m_130136_(16);
                groups.add(new DogGroupsManager.DogGroup(name, color));
            }
            return new HeelByGroupData.RESPONSE_GROUP_LIST(groups);
        }

        @Override
        public void handle(HeelByGroupData.RESPONSE_GROUP_LIST data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Minecraft mc = Minecraft.m_91087_();
                    Screen screen = mc.f_91080_;
                    if (screen instanceof HeelByGroupScreen) {
                        HeelByGroupScreen groupScreen = (HeelByGroupScreen)screen;
                        groupScreen.assignResponse(data.groups);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class REQUEST_GROUP_LIST
    implements IPacket<HeelByGroupData.REQUEST_GROUP_LIST> {
        @Override
        public void encode(HeelByGroupData.REQUEST_GROUP_LIST data, FriendlyByteBuf buf) {
        }

        @Override
        public HeelByGroupData.REQUEST_GROUP_LIST decode(FriendlyByteBuf buf) {
            return new HeelByGroupData.REQUEST_GROUP_LIST();
        }

        @Override
        public void handle(HeelByGroupData.REQUEST_GROUP_LIST data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
                if (!side.isServer()) {
                    return;
                }
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                List dogsList = sender.m_9236_().m_6443_(Dog.class, sender.m_20191_().m_82377_(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.m_21830_((LivingEntity)sender));
                ArrayList<DogGroupsManager.DogGroup> groups_response = new ArrayList<DogGroupsManager.DogGroup>();
                for (Dog dog2 : dogsList) {
                    List<DogGroupsManager.DogGroup> groups = dog2.getGroups().getGroupsReadOnly();
                    for (DogGroupsManager.DogGroup group : groups) {
                        if (groups_response.contains(group)) continue;
                        groups_response.add(group);
                    }
                }
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new HeelByGroupData.RESPONSE_GROUP_LIST(groups_response));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

