/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ShockAbsorberTalent
extends TalentInstance {
    public ShockAbsorberTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        AttributeInstance attrib = dogIn.m_21051_(Attributes.f_22278_);
        if (attrib == null) {
            return;
        }
        attrib.m_22100_(this.getKnockbackResist());
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        AttributeInstance attrib = dogIn.m_21051_(Attributes.f_22278_);
        if (attrib == null) {
            return;
        }
        attrib.m_22100_(this.getKnockbackResist());
    }

    @Override
    public void remove(AbstractDog dogIn) {
        AttributeInstance attrib = dogIn.m_21051_(Attributes.f_22278_);
        if (attrib == null) {
            return;
        }
        attrib.m_22100_(0.25);
    }

    @Override
    public InteractionResult negateExplosion(AbstractDog dog) {
        if (this.level() >= this.talent.getMaxLevel()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Float> gettingAttackedFrom(AbstractDog dog, DamageSource source, float damage) {
        if (this.isExplosionSource(source)) {
            return InteractionResultHolder.m_19090_((Object)Float.valueOf(damage * this.getExplosionResist()));
        }
        return InteractionResultHolder.m_19098_((Object)Float.valueOf(damage));
    }

    private boolean isExplosionSource(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            return true;
        }
        return source.m_276093_(DamageTypes.f_268679_);
    }

    public double getKnockbackResist() {
        int level = this.level();
        if (level >= 5) {
            return 1.0;
        }
        switch (level) {
            case 0: {
                return 0.25;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.6;
            }
            case 3: {
                return 0.75;
            }
            case 4: {
                return 0.9;
            }
        }
        return 0.25;
    }

    public float getExplosionResist() {
        int level = this.level();
        if (level >= 5) {
            return 1.0f;
        }
        if (level < 0) {
            return 0.0f;
        }
        return 0.2f * (float)level;
    }
}

