/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.common.entity.Dog;
import doggytalents.common.item.IDyeableArmorItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;

public class ItemUtil {
    private static int MAX_OVERVIEW = 3;

    public static ContentOverview getContentOverview(IItemHandler inventory) {
        HashMap<Item, Integer> retMap = new HashMap<Item, Integer>(MAX_OVERVIEW);
        int isMore = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            Integer existing = retMap.get(item);
            if (existing != null) {
                retMap.put(item, existing + stack.m_41613_());
                continue;
            }
            if (retMap.size() >= MAX_OVERVIEW) {
                ++isMore;
                continue;
            }
            retMap.put(item, stack.m_41613_());
        }
        return new ContentOverview(retMap, isMore);
    }

    public static CompoundTag getTag(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return new CompoundTag();
        }
        return tag;
    }

    public static void clearTag(ItemStack stack) {
        stack.m_41751_(null);
    }

    public static void putTag(ItemStack stack, CompoundTag tag) {
        stack.m_41751_(tag);
    }

    public static void modifyTag(ItemStack stack, Consumer<CompoundTag> tag_modifier) {
        CompoundTag tag = stack.m_41784_();
        tag_modifier.accept(tag);
    }

    public static CompoundTag getTagElement(ItemStack stack, String id) {
        CompoundTag tag = ItemUtil.getTag(stack);
        if (!tag.m_128425_(id, 10)) {
            return null;
        }
        return tag.m_128469_(id);
    }

    public static boolean hasTag(ItemStack stack) {
        return stack.m_41782_();
    }

    public static void copyTag(ItemStack from, ItemStack to) {
        CompoundTag from_tag = from.m_41783_();
        from_tag = from_tag != null ? from_tag.m_6426_() : new CompoundTag();
        to.m_41751_(from_tag);
    }

    public static boolean fireResistant(ItemStack stack) {
        return stack.m_41720_().m_41475_();
    }

    public static boolean isEddible(ItemStack stack) {
        return stack.m_41614_();
    }

    public static boolean hasCustomHoverName(ItemStack stack) {
        return stack.m_41788_();
    }

    public static Component getCustomHoverName(ItemStack stack) {
        return stack.m_41786_();
    }

    public static void clearCustomHoverName(ItemStack stack) {
        stack.m_41787_();
    }

    public static int getDyeColorForStack(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IDyeableArmorItem) {
            IDyeableArmorItem dye = (IDyeableArmorItem)item;
            return 0xFF000000 | dye.m_41121_(stack);
        }
        return -1;
    }

    public static void setDyeColorForStack(ItemStack stack, int color) {
        Item item = stack.m_41720_();
        if (!(item instanceof IDyeableArmorItem)) {
            return;
        }
        IDyeableArmorItem dye = (IDyeableArmorItem)item;
        dye.m_41115_(stack, color);
    }

    public static Optional<ArmorTrim> getTrim(Dog dog, ItemStack stack) {
        return ArmorTrim.m_266285_((RegistryAccess)dog.m_9236_().m_9598_(), (ItemStack)stack);
    }

    public static FoodProperties food(ItemStack stack) {
        return stack.getFoodProperties(null);
    }

    public static CompoundTag getWrappedTag(ItemStack stack) {
        return ItemUtil.getTag(stack);
    }

    public static int getEnchantmentLevelForItem(Enchantment enchantment, RegistryAccess prov, ItemStack stack) {
        return stack.getEnchantmentLevel(enchantment);
    }

    public static Optional<Ingredient> getBlockIngredient(Block block) {
        return Optional.ofNullable(block.m_5456_()).filter(item -> item != Items.f_41852_).map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0}));
    }

    public static void addCrossbowProj(ItemStack crossbow_stack, List<ItemStack> proj_stacks) {
        String CHARGED_PROJ_TAG = "ChargedProjectiles";
        CompoundTag crossbow_tag = crossbow_stack.m_41784_();
        ListTag listtag = crossbow_tag.m_128425_("ChargedProjectiles", 9) ? crossbow_tag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        for (ItemStack proj_stack : proj_stacks) {
            CompoundTag proj_tag = new CompoundTag();
            proj_stack.m_41739_(proj_tag);
            listtag.add((Object)proj_tag);
        }
        crossbow_tag.m_128365_("ChargedProjectiles", (Tag)listtag);
        CrossbowItem.m_40884_((ItemStack)crossbow_stack, (boolean)true);
    }

    public static class ContentOverview {
        private final Map<Item, Integer> contents;
        private int isMore = 0;

        private ContentOverview(Map<Item, Integer> contents, int isMore) {
            this.contents = contents;
            this.isMore = isMore;
        }

        public int isMore() {
            return this.isMore;
        }

        public Map<Item, Integer> contents() {
            return this.contents;
        }
    }
}

