/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.util.dogpromise.chunk.DTNForcedChunkManager;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractPromise {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/chunkTask");
    @Nullable
    private ServerPlayer owner;
    private State state;
    protected String rejectedMsg = "";
    private final Map<ResourceKey<Level>, AccquiredChunks> accquiredChunks = new HashMap<ResourceKey<Level>, AccquiredChunks>();

    public AbstractPromise() {
        this.state = State.PENDING;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public ServerPlayer getOwner() {
        return this.owner;
    }

    public void setOwner(ServerPlayer owner) {
        this.owner = owner;
    }

    public abstract void start();

    public abstract void tick();

    public abstract void onFulfilled();

    public abstract void onRejected();

    public void cleanUp() {
    }

    public final void doCleanUp() {
        this.dropAllAccquiredChunk();
        this.cleanUp();
    }

    protected final void accquireChunk(ServerLevel level, ChunkPos pos) {
        LongSet accquireds = this.accquiredChunks.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new AccquiredChunks(level)).chunks();
        boolean added = accquireds.add(pos.m_45588_());
        if (!added) {
            return;
        }
        DTNForcedChunkManager.accquireChunk(level, this, pos);
    }

    protected final void dropAllAccquiredChunk() {
        int drop_count = 0;
        for (Map.Entry<ResourceKey<Level>, AccquiredChunks> entry : this.accquiredChunks.entrySet()) {
            ServerLevel source = entry.getValue().source();
            LongSet chunks = entry.getValue().chunks();
            if (chunks.isEmpty()) continue;
            for (Long chunk : chunks) {
                DTNForcedChunkManager.dropChunk(source, this, new ChunkPos(chunk.longValue()));
                ++drop_count;
            }
        }
        this.accquiredChunks.clear();
    }

    public void forceReject() {
        this.setState(State.REJECTED);
        this.rejectedMsg = "FORCED";
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public static enum State {
        PENDING,
        RUNNING,
        FULFILLED,
        REJECTED;

    }

    private record AccquiredChunks(ServerLevel source, LongSet chunks) {
        public AccquiredChunks(ServerLevel source) {
            this(source, (LongSet)new LongOpenHashSet());
        }
    }
}

