/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class DogDistantTeleportToOwnerCrossDimensionPromise
extends AbstractPromise {
    private static final int TIMEOUT = 200;
    private static final int SEARCH_INTERVAL = 10;
    private final BlockPos targetPos;
    private final BlockPos dogPos;
    private final UUID dogUUID;
    private final ServerLevel ownerLevel;
    private final ServerLevel dogLevel;
    private int timeOutTick;
    private int tickTillSearch;
    private Dog teleportedDog;
    private final LivingEntity owner;
    private boolean dogChunkForced;

    public DogDistantTeleportToOwnerCrossDimensionPromise(@Nonnull UUID dogUUID, @Nonnull LivingEntity owner, @Nonnull BlockPos dogPos, ServerLevel dogLevel, ServerLevel ownerLevel) {
        this.dogUUID = dogUUID;
        this.ownerLevel = ownerLevel;
        this.targetPos = owner.m_20183_();
        this.dogPos = dogPos;
        this.owner = owner;
        this.dogLevel = dogLevel;
    }

    @Override
    public void tick() {
        if (this.dogLevel == this.ownerLevel) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Entity e = null;
        if (--this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            e = this.dogLevel.m_8791_(this.dogUUID);
        }
        if (e == null) {
            if (--this.timeOutTick <= 0) {
                this.rejectedMsg = "TIMEOUT";
                this.setState(AbstractPromise.State.REJECTED);
            }
            return;
        }
        if (!(e instanceof Dog)) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Dog dog = (Dog)e;
        List<BlockPos> safePosList = CachedSearchUtil.getAllSafePosUsingPool((Level)this.ownerLevel, List.of((Dog)e), this.targetPos, 4, 1);
        if (safePosList.isEmpty()) {
            this.rejectedMsg = "NOSAFEPOS";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        int r = dog.m_217043_().m_188503_(safePosList.size());
        BlockPos safePos = safePosList.get(r);
        dog.authorizeChangeDimension();
        Entity dogafterTp = dog.changeDimension(this.ownerLevel, new DogTeleporter(safePos));
        if (dogafterTp instanceof Dog) {
            this.teleportedDog = (Dog)dogafterTp;
        }
        this.setState(AbstractPromise.State.FULFILLED);
    }

    @Override
    public void onFulfilled() {
        if (this.teleportedDog == null || !this.teleportedDog.m_6084_()) {
            return;
        }
        if (this.owner != null) {
            this.owner.m_213846_((Component)Component.m_237110_((String)"item.doggytalents.conducting_bone.fulfilled.tp_self", (Object[])new Object[]{this.teleportedDog.m_7755_().getString()}));
        }
        this.ownerLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.teleportedDog.m_20185_(), this.teleportedDog.m_20186_(), this.teleportedDog.m_20189_(), 30, (double)this.teleportedDog.m_20205_(), (double)0.8f, (double)this.teleportedDog.m_20205_(), 0.1);
    }

    @Override
    public void onRejected() {
        if (this.owner != null) {
            this.owner.m_213846_((Component)Component.m_237110_((String)"item.doggytalents.conducting_bone.rejected", (Object[])new Object[]{Component.m_237113_((String)this.rejectedMsg).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED))}));
        }
    }

    @Override
    public void start() {
        if (this.ownerLevel == null || this.dogLevel == null) {
            this.rejectedMsg = "CLIENTLEVEL";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (this.ownerLevel == this.dogLevel) {
            this.rejectedMsg = "SAMEDIM";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.timeOutTick = 200;
        ChunkPos chunkpos = new ChunkPos(this.dogPos);
        if (this.dogLevel.m_7232_(chunkpos.f_45578_, chunkpos.f_45579_)) {
            return;
        }
        this.accquireChunk(this.dogLevel, chunkpos);
    }

    private static class DogTeleporter
    implements ITeleporter {
        private BlockPos safePos;

        public DogTeleporter(BlockPos safePos) {
            this.safePos = safePos;
        }

        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return new PortalInfo(Vec3.m_82539_((Vec3i)this.safePos), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
        }
    }
}

