/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.variant.util;

import doggytalents.DoggyRegistries;
import doggytalents.common.util.Util;
import doggytalents.common.variant.DogVariant;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.registries.IForgeRegistry;

public class DogVariantUtil {
    public static DogVariant getDefault() {
        return DogVariant.PALE;
    }

    public static DogVariant getMissing() {
        return DogVariant.MISSING;
    }

    public static DogVariant fromSaveString(String string) {
        return DogVariantUtil.fromSaveString(string, id -> {});
    }

    public static DogVariant fromSaveString(String string, Consumer<ResourceLocation> missingSetter) {
        boolean handle_missing;
        ResourceLocation id = null;
        try {
            id = Util.parseResource(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id == null) {
            return DogVariantUtil.getDefault();
        }
        DogVariant variant = (DogVariant)DoggyRegistries.DOG_VARIANT.get().getValue(id);
        if (variant == null) {
            return DogVariantUtil.getDefault();
        }
        boolean bl = handle_missing = variant == DogVariantUtil.getMissing() && !id.equals((Object)DogVariantUtil.getMissing().id());
        if (handle_missing) {
            missingSetter.accept(id);
            return DogVariantUtil.getMissing();
        }
        if (variant == DogVariantUtil.getMissing()) {
            variant = DogVariantUtil.getDefault();
        }
        return variant;
    }

    public static String toSaveString(DogVariant variant) {
        return DogVariantUtil.toSaveString(variant, () -> Optional.empty());
    }

    public static String toSaveString(DogVariant variant, Supplier<Optional<ResourceLocation>> missingGetter) {
        if (variant == null) {
            variant = DogVariantUtil.getDefault();
        }
        if (variant == DogVariantUtil.getMissing()) {
            Optional<ResourceLocation> missing = missingGetter.get();
            if (missing.isPresent()) {
                return missing.get().toString();
            }
            return DogVariantUtil.getDefault().id().toString();
        }
        return variant.id().toString();
    }

    public static List<DogVariant> getAll() {
        IForgeRegistry<DogVariant> variant_reg = DoggyRegistries.DOG_VARIANT.get();
        List<DogVariant> entries = variant_reg.getValues().stream().filter(x -> x != DogVariantUtil.getMissing()).collect(Collectors.toList());
        return entries;
    }

    public static List<DogVariant> getAllWithMissing() {
        IForgeRegistry<DogVariant> variant_reg = DoggyRegistries.DOG_VARIANT.get();
        List<DogVariant> entries = variant_reg.getValues().stream().collect(Collectors.toList());
        return entries;
    }

    public static DogVariant getRandom(RandomSource random) {
        List<DogVariant> entries = DogVariantUtil.getAll();
        if (entries.isEmpty()) {
            return DogVariantUtil.getDefault();
        }
        int r = random.m_188503_(entries.size());
        return entries.get(r);
    }

    public static DogVariant cycle(DogVariant current) {
        List<DogVariant> entries = DogVariantUtil.getAll();
        if (entries.isEmpty()) {
            return DogVariantUtil.getDefault();
        }
        int current_indx = entries.indexOf(current);
        int next_indx = (current_indx + 1) % entries.size();
        DogVariant next_variant = entries.get(next_indx);
        return next_variant;
    }
}

