/*
 * Decompiled with CFR 0.152.
 */
package liedge.bannercapes;

import liedge.bannercapes.BannerCapeItem;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.gameevent.GameEvent;

public class BannerElytraCapeItem
extends BannerCapeItem {
    public BannerElytraCapeItem(Item.Properties properties, DyeColor baseColor) {
        super(properties, baseColor);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Items.PHANTOM_MEMBRANE);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ElytraItem.isFlyEnabled((ItemStack)stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextTick;
        if (!entity.level().isClientSide() && (nextTick = flightTicks + 1) % 10 == 0) {
            if (nextTick % 20 == 0) {
                stack.hurtAndBreak(1, entity, EquipmentSlot.CHEST);
            }
            entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
        }
        return true;
    }

    public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_ELYTRA;
    }
}

