/*
 * Decompiled with CFR 0.152.
 */
package liedge.bannercapes.client;

import liedge.bannercapes.BannerCapes;
import liedge.bannercapes.client.BannerCapeLayer;
import liedge.bannercapes.client.CuriosIntegration;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@Mod(value="bannercapes", dist={Dist.CLIENT})
public class BannerCapesClient {
    public BannerCapesClient(IEventBus modBus, ModContainer modContainer) {
        modBus.register((Object)new ClientSetup());
    }

    private static class ClientSetup {
        private ClientSetup() {
        }

        @SubscribeEvent
        private void clientSetup(FMLClientSetupEvent event) {
            if (CuriosIntegration.isCuriosLoaded()) {
                CuriosIntegration.registerCuriosRenderers();
                BannerCapes.LOGGER.info("Registered banner capes curios renderers.");
            } else {
                BannerCapes.LOGGER.info("Skipping banner capes curios renderer registration since Curios is not installed.");
            }
        }

        @SubscribeEvent
        private void addLayers(EntityRenderersEvent.AddLayers event) {
            for (PlayerSkin.Model model : event.getSkins()) {
                PlayerRenderer renderer = (PlayerRenderer)event.getSkin(model);
                if (renderer == null) continue;
                renderer.addLayer((RenderLayer)new BannerCapeLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
            }
        }
    }
}

