/*
 * Decompiled with CFR 0.152.
 */
package liedge.bannercapes.registry;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import liedge.bannercapes.BannerCapeItem;
import liedge.bannercapes.BannerElytraCapeItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class BannerCapesItems {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"bannercapes");
    public static final DeferredItem<Item> CAPE_HARNESS = ITEMS.registerSimpleItem("cape_harness");
    public static final Map<DyeColor, DeferredItem<BannerCapeItem>> BANNER_CAPES = BannerCapesItems.registerCapes("banner_cape", BannerCapeItem::new, properties -> properties.stacksTo(1).component(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY));
    public static final Map<DyeColor, DeferredItem<BannerElytraCapeItem>> BANNER_ELYTRA_CAPES = BannerCapesItems.registerCapes("banner_elytra_cape", BannerElytraCapeItem::new, properties -> properties.durability(432).component(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY).rarity(Rarity.UNCOMMON));

    private BannerCapesItems() {
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
    }

    private static <T extends Item> Map<DyeColor, DeferredItem<T>> registerCapes(String name, BiFunction<Item.Properties, DyeColor, T> constructor, UnaryOperator<Item.Properties> propertiesOp) {
        EnumMap<DyeColor, DeferredItem> map = new EnumMap<DyeColor, DeferredItem>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            DeferredItem holder = ITEMS.register(color.getSerializedName() + "_" + name, () -> (Item)constructor.apply((Item.Properties)propertiesOp.apply(new Item.Properties()), color));
            map.put(color, holder);
        }
        return ImmutableMap.copyOf(map);
    }
}

