/*
 * Decompiled with CFR 0.152.
 */
package net.biohazardcraft.init;

import net.biohazardcraft.entity.BulletEntity;
import net.biohazardcraft.entity.DeathSurviosEntity;
import net.biohazardcraft.entity.MedzombieEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class BiohazardcraftModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"biohazardcraft");
    public static final DeferredHolder<EntityType<?>, EntityType<MedzombieEntity>> MEDZOMBIE = BiohazardcraftModEntities.register("medzombie", EntityType.Builder.of(MedzombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<DeathSurviosEntity>> DEATH_SURVIOS = BiohazardcraftModEntities.register("death_survios", EntityType.Builder.of(DeathSurviosEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BulletEntity>> BULLET = BiohazardcraftModEntities.register("bullet", EntityType.Builder.of(BulletEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.4f, 0.4f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MedzombieEntity.init(event);
        DeathSurviosEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MEDZOMBIE.get(), MedzombieEntity.createAttributes().build());
        event.put((EntityType)DEATH_SURVIOS.get(), DeathSurviosEntity.createAttributes().build());
    }
}

