/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.hud;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.thermoo.api.client.HeartBarContext;
import com.github.thedeathlycow.thermoo.api.client.StatusBarOverlayRenderEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public final class SoakingUnderlay
implements StatusBarOverlayRenderEvents.RenderHealthBarCallback {
    public static final SoakingUnderlay INSTANCE = new SoakingUnderlay();
    public static final class_2960 TEXTURE = Scorchful.id("textures/gui/soaking_overlay.png");
    public static final int TEXTURE_WIDTH = 9;
    public static final int TEXTURE_HEIGHT = 10;

    public void render(class_332 context, class_1657 player, HeartBarContext heartBarContext) {
        if (!ScorchfulConfig.getClientConfig().doSoakingOverlay() || !player.thermoo$isWet()) {
            return;
        }
        int soakedPoints = SoakingUnderlay.getNumSoakingPoints(player, heartBarContext.positions().size());
        int soakedHearts = SoakingUnderlay.getFullSoakedHeartsFromPoints(soakedPoints);
        boolean drawHalfHeartAtEnd = soakedHearts % 2 != 0;
        int heartsRendered = 0;
        for (Vector2i position : heartBarContext.positions()) {
            if (heartsRendered >= soakedHearts) break;
            boolean isHalfHeart = drawHalfHeartAtEnd && heartsRendered == soakedHearts - 1;
            int width = isHalfHeart ? 5 : 9;
            context.method_25290(class_10799.field_56883, TEXTURE, position.x(), position.y() - 1, 0.0f, 0.0f, width, 10, 9, 10);
            ++heartsRendered;
        }
    }

    private static int getNumSoakingPoints(@NotNull class_1657 player, int maxDisplayHealth) {
        float soakedScale = player.thermoo$getSoakedScale();
        return Math.round(soakedScale * (float)maxDisplayHealth * 2.0f);
    }

    private static int getFullSoakedHeartsFromPoints(int soakedPoints) {
        return class_3532.method_15386((float)((float)soakedPoints / 2.0f));
    }

    private SoakingUnderlay() {
    }
}

