/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.HeatingConfig;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.TemperatureRecordComponent;
import com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class ServerPlayerEnvironmentTickListeners {
    public static void initialize() {
        ServerPlayerEnvironmentTickEvents.GET_TEMPERATURE_CHANGE.register(ServerPlayerEnvironmentTickListeners::getTemperatureChange);
        ServerPlayerEnvironmentTickEvents.ALLOW_TEMPERATURE_CHANGE.register(ServerPlayerEnvironmentTickListeners::allowTemperatureChange);
    }

    private static int getTemperatureChange(EnvironmentTickContext<class_3222> context) {
        if (((class_3222)context.affected()).method_7325()) {
            return 0;
        }
        TemperatureRecord temperature = (TemperatureRecord)context.components().method_58695(EnvironmentComponentTypes.TEMPERATURE, (Object)TemperatureRecordComponent.DEFAULT);
        int total = ServerPlayerEnvironmentTickListeners.environmentTemperatureToTemperatureChange(temperature, ScorchfulConfig.getHeatingConfig());
        if (((class_3222)context.affected()).field_6012 % 20 == 0 && Scorchful.LOGGER.isDebugEnabled()) {
            Scorchful.LOGGER.debug("Adding {} temperature to {}", (Object)total, (Object)((class_3222)context.affected()).method_5820());
        }
        return total;
    }

    private static TriState allowTemperatureChange(EnvironmentTickContext<class_3222> context, int temperatureChange) {
        if (temperatureChange <= 0) {
            return TriState.DEFAULT;
        }
        class_3222 player = (class_3222)context.affected();
        HeatingConfig config = ScorchfulConfig.getHeatingConfig();
        int tickInterval = config.getPassiveHeatingTickInterval();
        if (tickInterval > 1 && player.field_6012 % tickInterval != 0) {
            return TriState.FALSE;
        }
        if (!config.doPassiveHeating()) {
            return TriState.FALSE;
        }
        return TriState.of((player.thermoo$getTemperatureScale() < config.getMaxPassiveHeatingScale() ? 1 : 0) != 0);
    }

    static int environmentTemperatureToTemperatureChange(TemperatureRecord temperature, HeatingConfig config) {
        double temperatureC = temperature.valueInUnit(TemperatureUnit.CELSIUS);
        double thresholdC = config.getMinTemperatureForHeatC();
        double degreesPerTemperatureIncrease = config.getDegreesCPerTemperatureIncrease();
        if (temperatureC < thresholdC) {
            return 0;
        }
        double base = (temperatureC - thresholdC + degreesPerTemperatureIncrease) / degreesPerTemperatureIncrease;
        return class_3532.method_15357((double)(config.getEnvironmentTemperatureMultiplier() * base));
    }
}

