/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.mixin.common;

import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import com.github.thedeathlycow.thermoo.api.ThermooTags;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.Soakable;
import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.github.thedeathlycow.thermoo.impl.component.EnvironmentComponent;
import com.github.thedeathlycow.thermoo.impl.component.ThermooComponents;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class EnvironmentAwareEntityMixin
extends class_1297
implements TemperatureAware,
Soakable {
    private static final int BASE_MAX_SOAK_TICKS = 600;

    @Shadow
    public abstract boolean method_6094();

    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    public EnvironmentAwareEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public void thermoo$setWetTicks(int amount) {
        int value = class_3532.method_15340((int)amount, (int)0, (int)this.thermoo$getMaxWetTicks());
        ((EnvironmentComponent)ThermooComponents.WETNESS.get((Object)this)).setValue(value);
    }

    @Override
    public int thermoo$getWetTicks() {
        return ((EnvironmentComponent)ThermooComponents.WETNESS.get((Object)this)).getValue();
    }

    @Override
    public int thermoo$getMaxWetTicks() {
        double multiplier = this.method_45325(ThermooAttributes.MAX_SOAKING_TICK_MULTIPLIER);
        return class_3532.method_15357((double)(600.0 * multiplier));
    }

    @Override
    public boolean thermoo$ignoresFrigidWater() {
        boolean canBreatheInWater = this.method_6094() || this.method_6059((class_6880<class_1291>)class_1294.field_5923) || this.method_6059((class_6880<class_1291>)class_1294.field_5927);
        return canBreatheInWater && this.method_5869();
    }

    @Override
    public int thermoo$getTemperature() {
        return ((EnvironmentComponent)ThermooComponents.TEMPERATURE.get((Object)this)).getValue();
    }

    @Override
    public void thermoo$setTemperature(int temperature) {
        int value = class_3532.method_15340((int)temperature, (int)this.thermoo$getMinTemperature(), (int)this.thermoo$getMaxTemperature());
        ((EnvironmentComponent)ThermooComponents.TEMPERATURE.get((Object)this)).setValue(value);
    }

    @Override
    public int thermoo$getMinTemperature() {
        double minTemp = this.method_45325(ThermooAttributes.MIN_TEMPERATURE);
        return -((int)(minTemp * 140.0));
    }

    @Override
    public int thermoo$getMaxTemperature() {
        double maxTemp = this.method_45325(ThermooAttributes.MAX_TEMPERATURE);
        return (int)(maxTemp * 140.0);
    }

    @Override
    public double thermoo$getColdResistance() {
        return this.method_45325(ThermooAttributes.FROST_RESISTANCE);
    }

    @Override
    public double thermoo$getHeatResistance() {
        return this.method_45325(ThermooAttributes.HEAT_RESISTANCE);
    }

    @Override
    public double thermoo$getEnvironmentColdResistance() {
        return this.method_45325(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE);
    }

    @Override
    public double thermoo$getEnvironmentHeatResistance() {
        return this.method_45325(ThermooAttributes.ENVIRONMENT_HEAT_RESISTANCE);
    }

    @Override
    public boolean thermoo$canFreeze() {
        class_1299 type = this.method_5864();
        if (this.method_7325()) {
            return false;
        }
        if (type.method_20210(ThermooTags.BENEFITS_FROM_COLD_ENTITY_TYPE)) {
            return true;
        }
        if (type.method_20210(ThermooTags.COLD_IMMUNE_ENTITY_TYPE)) {
            return false;
        }
        EnvironmentAwareEntityMixin environmentAwareEntityMixin = this;
        if (environmentAwareEntityMixin instanceof class_1657) {
            class_1657 player = (class_1657)environmentAwareEntityMixin;
            return !player.method_68878();
        }
        return true;
    }

    @Override
    public boolean thermoo$canOverheat() {
        class_1299 type = this.method_5864();
        if (this.method_7325()) {
            return false;
        }
        if (type.method_20210(ThermooTags.BENEFITS_FROM_HEAT_ENTITY_TYPE)) {
            return true;
        }
        if (type.method_20210(ThermooTags.HEAT_IMMUNE_ENTITY_TYPE)) {
            return false;
        }
        EnvironmentAwareEntityMixin environmentAwareEntityMixin = this;
        if (environmentAwareEntityMixin instanceof class_1657) {
            class_1657 player = (class_1657)environmentAwareEntityMixin;
            return !player.method_68878();
        }
        return true;
    }

    @Override
    public void thermoo$addTemperature(int temperatureChange, HeatingMode mode) {
        boolean isFreezing;
        if (temperatureChange == 0) {
            return;
        }
        boolean bl = isFreezing = temperatureChange < 0;
        if (isFreezing && !this.thermoo$canFreeze() || !isFreezing && !this.thermoo$canOverheat()) {
            return;
        }
        int currentTemperature = this.thermoo$getTemperature();
        int modifiedChange = mode.applyResistance(this, temperatureChange);
        this.thermoo$setTemperature(currentTemperature + modifiedChange);
    }

    @Override
    public class_5819 thermoo$getRandom() {
        return this.field_5974;
    }

    @Inject(method={"method_26827()Lnet/minecraft/class_5132$class_5133;"}, at={@At(value="TAIL")})
    private static void addThermooAttributesToLivingEntities(CallbackInfoReturnable<class_5132.class_5133> cir) {
        class_5132.class_5133 builder = (class_5132.class_5133)cir.getReturnValue();
        builder.method_26867(ThermooAttributes.MIN_TEMPERATURE);
        builder.method_26867(ThermooAttributes.MAX_TEMPERATURE);
        builder.method_26867(ThermooAttributes.MAX_SOAKING_TICK_MULTIPLIER);
        builder.method_26867(ThermooAttributes.FROST_RESISTANCE);
        builder.method_26867(ThermooAttributes.HEAT_RESISTANCE);
        builder.method_26867(ThermooAttributes.ENVIRONMENT_HEAT_RESISTANCE);
        builder.method_26867(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE);
    }
}

