/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderType;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProviderTypes;
import com.github.thedeathlycow.thermoo.api.environment.provider.SeasonalEnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeason;
import com.github.thedeathlycow.thermoo.impl.environment.SeasonalProviderBuilderHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TemperateSeasonEnvironmentProvider
extends SeasonalEnvironmentProvider {
    public static final MapCodec<TemperateSeasonEnvironmentProvider> CODEC = TemperateSeasonEnvironmentProvider.validate(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ThermooSeason.CODEC.optionalFieldOf("fallback_season").forGetter(SeasonalEnvironmentProvider::fallbackSeason), (App)SeasonalEnvironmentProvider.createSeasonMapCodec().validate(TemperateSeasonEnvironmentProvider::allKeysAreTemperate).fieldOf("seasons").forGetter(SeasonalEnvironmentProvider::seasons)).apply((Applicative)instance, TemperateSeasonEnvironmentProvider::new)));

    @Contract(value="->new")
    public static Builder builder() {
        return new Builder();
    }

    private TemperateSeasonEnvironmentProvider(Optional<ThermooSeason> fallbackSeason, Map<ThermooSeason, class_6880<EnvironmentProvider>> seasons) {
        super(fallbackSeason, seasons);
    }

    public EnvironmentProviderType<TemperateSeasonEnvironmentProvider> getType() {
        return EnvironmentProviderTypes.TEMPERATE_SEASONAL;
    }

    @Override
    protected Optional<ThermooSeason> getCurrentSeason(class_1937 world, class_2338 pos) {
        return ThermooSeason.getCurrentSeason(world);
    }

    private static DataResult<Map<ThermooSeason, class_6880<EnvironmentProvider>>> allKeysAreTemperate(Map<ThermooSeason, class_6880<EnvironmentProvider>> seasonMap) {
        for (ThermooSeason season : seasonMap.keySet()) {
            if (!season.isTropical()) continue;
            return DataResult.error(() -> "Found tropical season '" + season.name() + "' in a temperate season map!");
        }
        return DataResult.success(seasonMap);
    }

    public static final class Builder {
        private final SeasonalProviderBuilderHelper helper = new SeasonalProviderBuilderHelper();

        private Builder() {
        }

        @Contract(value="_->this")
        public Builder withFallbackSeason(@NotNull ThermooSeason season) {
            Objects.requireNonNull(season);
            if (!season.isTropical()) {
                this.helper.setFallbackSeason(season);
            }
            return this;
        }

        @Contract(value="_,_->this")
        public Builder addSeasonProvider(@NotNull ThermooSeason season, @NotNull class_6880<EnvironmentProvider> provider) {
            Objects.requireNonNull(season);
            if (!season.isTropical()) {
                this.helper.setSeasonProvider(season, provider);
            }
            return this;
        }

        @Contract(value="->new")
        public TemperateSeasonEnvironmentProvider build() {
            this.helper.validate();
            return new TemperateSeasonEnvironmentProvider(Optional.ofNullable(this.helper.getFallbackSeason()), this.helper.getSeasons());
        }
    }
}

