/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.HeatingConfig;
import com.github.thedeathlycow.scorchful.config.section.ThirstConfig;
import com.github.thedeathlycow.scorchful.registry.tag.SBlockTags;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents;
import net.minecraft.class_1309;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public final class PassiveTemperatureEffects {
    private static final double LOW_HUMIDITY = 0.2;
    private static final double HIGH_HUMIDITY = 0.65;
    private static final double VERY_HIGH_HUMIDITY = 0.8;

    public static void initialize() {
        LivingEntityTemperatureTickEvents.GET_PASSIVE_TEMPERATURE_CHANGE.register(PassiveTemperatureEffects::getPassiveChange);
    }

    private static int getPassiveChange(EnvironmentTickContext<? extends class_1309> context) {
        class_1309 entity = (class_1309)context.affected();
        if (entity.method_7325() || entity.thermoo$getTemperature() < 0) {
            return 0;
        }
        int total = 0;
        total += PassiveTemperatureEffects.getIcyFloorTemperatureChange(context, ScorchfulConfig.getHeatingConfig());
        return total += PassiveTemperatureEffects.getTemperatureFromSweat(context, ScorchfulConfig.getThirstConfig());
    }

    private static int getIcyFloorTemperatureChange(EnvironmentTickContext<? extends class_1309> context, HeatingConfig config) {
        class_1309 entity = (class_1309)context.affected();
        class_2680 steppingState = entity.method_25936();
        if (steppingState.method_26164(SBlockTags.HEAVY_ICE) && entity.thermoo$isWarm()) {
            return -config.getCoolingFromIce();
        }
        return 0;
    }

    private static int getTemperatureFromSweat(EnvironmentTickContext<? extends class_1309> context, ThirstConfig config) {
        class_1309 entity = (class_1309)context.affected();
        if (entity.thermoo$isWet()) {
            int temperatureChange = config.getTemperatureFromWetness();
            if (!((class_1309)context.affected()).method_5869()) {
                float efficiency = PassiveTemperatureEffects.getSweatEfficiency(context, config);
                temperatureChange = class_3532.method_15375((float)((float)temperatureChange * efficiency));
            }
            return temperatureChange;
        }
        return 0;
    }

    private static float getSweatEfficiency(EnvironmentTickContext<? extends class_1309> context, ThirstConfig config) {
        double relativeHumidity = (Double)context.components().method_58695(EnvironmentComponentTypes.RELATIVE_HUMIDITY, (Object)0.5);
        if (relativeHumidity <= 0.2) {
            return config.getAridBiomeSweatEfficiency();
        }
        if (relativeHumidity >= 0.8) {
            return config.getExtraHumidBiomeSweatEfficiency();
        }
        if (relativeHumidity >= 0.65) {
            return config.getHumidBiomeSweatEfficiency();
        }
        return 1.0f;
    }

    private PassiveTemperatureEffects() {
    }
}

