/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.api.ThermooRegistries;
import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_6885;
import net.minecraft.class_8567;
import org.jetbrains.annotations.ApiStatus;

public final class ConfiguredTemperatureEffect<C> {
    private final TemperatureEffect<C> type;
    private final C config;
    private final Optional<class_5341> predicate;
    private final class_6885<class_1299<?>> entityTypes;
    private final class_2096.class_2099 temperatureScaleRange;
    private final int loadingPriority;
    public static final Codec<ConfiguredTemperatureEffect<?>> CODEC = ThermooRegistries.TEMPERATURE_EFFECTS.method_39673().dispatch("type", ConfiguredTemperatureEffect::type, TemperatureEffect::getCodec);

    @ApiStatus.Internal
    public ConfiguredTemperatureEffect(TemperatureEffect<C> type, C config, Optional<class_5341> predicate, class_6885<class_1299<?>> entityTypes, class_2096.class_2099 temperatureScaleRange, int loadingPriority) {
        this.type = type;
        this.config = config;
        this.predicate = predicate;
        this.entityTypes = entityTypes;
        this.temperatureScaleRange = temperatureScaleRange;
        this.loadingPriority = loadingPriority;
    }

    @Deprecated
    public void applyIfPossible(class_1309 victim) {
        this.apply(victim);
    }

    public boolean apply(class_1309 victim) {
        boolean shouldApply;
        class_1937 world = victim.method_37908();
        if (world.field_9236) {
            return false;
        }
        class_3218 serverWorld = (class_3218)world;
        boolean bl = shouldApply = this.type.shouldApply(victim, this.config) && this.temperatureScaleRange.method_9047((double)victim.thermoo$getTemperatureScale()) && this.testPredicate(victim, serverWorld);
        if (shouldApply) {
            this.type.apply(victim, serverWorld, this.config);
            return true;
        }
        return false;
    }

    public void remove(class_1309 victim) {
        class_1937 world = victim.method_37908();
        if (world.field_9236) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        this.type.remove(victim, serverWorld, this.config);
    }

    private boolean testPredicate(class_1309 victim, class_3218 world) {
        return this.predicate.isEmpty() || this.predicate.get().test((Object)new class_47.class_48(new class_8567.class_8568(world).method_51874(class_181.field_1226, (Object)victim).method_51874(class_181.field_24424, (Object)victim.method_19538()).method_51875(class_173.field_20761)).method_309(Optional.empty()));
    }

    public TemperatureEffect<C> type() {
        return this.type;
    }

    public C config() {
        return this.config;
    }

    public Optional<class_5341> predicate() {
        return this.predicate;
    }

    public class_6885<class_1299<?>> entityTypes() {
        return this.entityTypes;
    }

    public class_2096.class_2099 temperatureScaleRange() {
        return this.temperatureScaleRange;
    }

    public int loadingPriority() {
        return this.loadingPriority;
    }
}

