/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public final class DamageTemperatureEffect
extends TemperatureEffect<Config> {
    public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_34387.fieldOf("amount").forGetter(Config::amount), (App)class_5699.field_33442.fieldOf("damage_interval").forGetter(Config::damageInterval), (App)class_5321.method_39154((class_5321)class_7924.field_42534).fieldOf("damage_type").forGetter(config -> config.damageType)).apply((Applicative)instance, Config::new));
    @Nullable
    private class_2378<class_8110> registry;
    private final Map<class_5321<class_8110>, class_1282> damageSourcePool = new HashMap<class_5321<class_8110>, class_1282>();

    public DamageTemperatureEffect(Codec<Config> codec) {
        super(codec);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> this.invalidateRegistryCache());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.invalidateRegistryCache());
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((server, resourceManager) -> this.invalidateRegistryCache());
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        class_1282 source;
        if (this.registry == null) {
            class_5455.class_6890 registryManager = serverWorld.method_8503().method_30611();
            this.registry = registryManager.method_30530(class_7924.field_42534);
        }
        if ((source = this.getDamageSourceFromType(config.damageType, this.registry)) != null) {
            victim.method_64397(serverWorld, source, config.amount);
        }
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        return victim.field_6012 % config.damageInterval == 0 && config.amount != 0.0f;
    }

    @Nullable
    private class_1282 getDamageSourceFromType(class_5321<class_8110> damageType, class_2378<class_8110> registry) {
        return this.damageSourcePool.computeIfAbsent(damageType, key -> {
            if (!registry.method_35842(key)) {
                Thermoo.LOGGER.error("Temperature effect trying to use unknown damage type {}", key);
                return null;
            }
            return new class_1282((class_6880)registry.method_46747(key));
        });
    }

    private void invalidateRegistryCache() {
        this.registry = null;
        this.damageSourcePool.clear();
        Thermoo.LOGGER.info("Invalidated damage temperature effect registry cache");
    }

    public record Config(float amount, int damageInterval, class_5321<class_8110> damageType) {
    }
}

