/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl.environment;

import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeason;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeasonalProviderBuilderHelper {
    @Nullable
    private ThermooSeason fallbackSeason = null;
    private final Map<ThermooSeason, class_6880<EnvironmentProvider>> seasons = new EnumMap<ThermooSeason, class_6880<EnvironmentProvider>>(ThermooSeason.class);

    @Nullable
    public ThermooSeason getFallbackSeason() {
        return this.fallbackSeason;
    }

    public Map<ThermooSeason, class_6880<EnvironmentProvider>> getSeasons() {
        return this.seasons;
    }

    public void setFallbackSeason(@NotNull ThermooSeason season) {
        Objects.requireNonNull(season);
        this.fallbackSeason = season;
    }

    public void setSeasonProvider(@NotNull ThermooSeason season, @NotNull class_6880<EnvironmentProvider> provider) {
        Objects.requireNonNull(season);
        Objects.requireNonNull(provider);
        this.seasons.put(season, provider);
    }

    public void validate() {
        if (this.seasons.isEmpty()) {
            throw new IllegalStateException("Cannot build a season provider with empty seasons map");
        }
        if (this.fallbackSeason != null && !this.seasons.containsKey((Object)this.fallbackSeason)) {
            throw new IllegalStateException("Fallback season is not a key of season provider map");
        }
    }
}

