/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="scorchful.heating_config")
public class HeatingConfig
implements ConfigData {
    boolean doPassiveHeating = true;
    int passiveHeatingTickInterval = 1;
    float maxPassiveHeatingScale = 1.0f;
    boolean enableTurtleArmorEffects = true;
    @ConfigEntry.Gui.Tooltip
    double minTemperatureForHeatC = 30.0;
    @ConfigEntry.Gui.Tooltip
    double degreesCPerTemperatureIncrease = 10.0;
    double environmentTemperatureMultiplier = 1.0;
    int coolingFromIce = 12;
    int onFireWarmRate = 24;
    int onFireWarmRateWithFireResistance = 6;
    int inLavaWarmRate = 24;
    int striderOutOfLavaCoolRate = 24;
    int powderSnowCoolRate = 24;
    int fireballHeat = 1000;
    float turtleArmorLungCapacityMultiplier = 1.0f;
    int temperatureFromCoolingFood = -1260;

    public boolean doPassiveHeating() {
        return this.doPassiveHeating;
    }

    public int getPassiveHeatingTickInterval() {
        return this.passiveHeatingTickInterval;
    }

    public float getMaxPassiveHeatingScale() {
        return this.maxPassiveHeatingScale;
    }

    public boolean isTurtleArmorEffectsEnabled() {
        return this.enableTurtleArmorEffects;
    }

    public double getMinTemperatureForHeatC() {
        return this.minTemperatureForHeatC;
    }

    public double getDegreesCPerTemperatureIncrease() {
        return this.degreesCPerTemperatureIncrease;
    }

    public double getEnvironmentTemperatureMultiplier() {
        return this.environmentTemperatureMultiplier;
    }

    public int getCoolingFromIce() {
        return this.coolingFromIce;
    }

    public int getOnFireWarmRate() {
        return this.onFireWarmRate;
    }

    public int getOnFireWarmRateWithFireResistance() {
        return this.onFireWarmRateWithFireResistance;
    }

    public int getInLavaWarmRate() {
        return this.inLavaWarmRate;
    }

    public int getStriderOutOfLavaCoolRate() {
        return this.striderOutOfLavaCoolRate;
    }

    public int getPowderSnowCoolRate() {
        return this.powderSnowCoolRate;
    }

    public int getFireballHeat() {
        return this.fireballHeat;
    }

    public float getTurtleArmorLungCapacityMultiplier() {
        return this.turtleArmorLungCapacityMultiplier;
    }

    public int getTemperatureFromCoolingFood() {
        return this.temperatureFromCoolingFood;
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        super.validatePostLoad();
        if (this.minTemperatureForHeatC < 25.0) {
            this.minTemperatureForHeatC = 25.0;
        }
        if (this.degreesCPerTemperatureIncrease <= 0.0) {
            throw new ConfigData.ValidationException("Degrees C Per Temperature Increase must be positive!");
        }
    }
}

