/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.hud;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.hud.BurningHeartType;
import com.github.thedeathlycow.thermoo.api.client.HeartBarContext;
import com.github.thedeathlycow.thermoo.api.client.StatusBarOverlayRenderEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public final class BurningHeartsOverlay
implements StatusBarOverlayRenderEvents.RenderHealthBarCallback {
    public static final BurningHeartsOverlay INSTANCE = new BurningHeartsOverlay();
    public static final class_2960 HEART_OVERLAY_TEXTURE = Scorchful.id("textures/gui/fire_heart_overlay.png");
    public static final int TEXTURE_WIDTH = 18;
    public static final int TEXTURE_HEIGHT = 30;

    public boolean drawEngulfedHeart(class_332 context, @Nullable class_1657 player, int x, int y, boolean hardcore, boolean halfHeart) {
        BurningHeartType type = BurningHeartType.forPlayer(player, hardcore);
        if (type != null) {
            context.method_25290(class_10799.field_56883, HEART_OVERLAY_TEXTURE, x, y - 1, halfHeart ? 9.0f : 0.0f, (float)type.textureV, 9, 10, 18, 30);
            return true;
        }
        return false;
    }

    public void render(class_332 context, class_1657 player, HeartBarContext heartBarContext) {
        ScorchfulConfig config = Scorchful.getConfig();
        if (!config.clientConfig.doBurningHeartOverlay() || player.thermoo$isCold()) {
            return;
        }
        int fireHalfHearts = BurningHeartsOverlay.getNumFireHalfHearts((class_1309)player, heartBarContext.positions().size());
        int fireHearts = BurningHeartsOverlay.getNumFireHearts(fireHalfHearts);
        boolean drawHalfHeartAtEnd = fireHalfHearts % 2 != 0;
        int heartsRendered = 0;
        for (Vector2i position : heartBarContext.positions()) {
            if (heartsRendered >= fireHearts) break;
            int x = position.x();
            int y = position.y() - 1;
            int u = drawHalfHeartAtEnd && heartsRendered == fireHearts - 1 ? 9 : 0;
            context.method_25290(class_10799.field_56883, HEART_OVERLAY_TEXTURE, x, y, (float)u, 0.0f, 9, 10, 18, 30);
            ++heartsRendered;
        }
    }

    static int getNumFireHalfHearts(@NotNull class_1309 entity, int maxDisplayHealth) {
        float overheatProgress = entity.thermoo$getTemperatureScale();
        return Math.round(overheatProgress * (float)maxDisplayHealth * 2.0f);
    }

    static int getNumFireHearts(int burningPoints) {
        return class_3532.method_15386((float)((float)burningPoints / 2.0f));
    }

    private BurningHeartsOverlay() {
    }
}

