/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.command.EnvironmentCommand;
import com.github.thedeathlycow.thermoo.api.command.HeatingModeArgumentType;
import com.github.thedeathlycow.thermoo.api.command.SoakingCommand;
import com.github.thedeathlycow.thermoo.api.command.TemperatureCommand;
import com.github.thedeathlycow.thermoo.api.command.TemperatureUnitArgumentType;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.impl.ThermooCommonRegisters;
import com.github.thedeathlycow.thermoo.impl.config.ThermooConfig;
import com.github.thedeathlycow.thermoo.impl.environment.EnvironmentLookupImpl;
import com.github.thedeathlycow.thermoo.impl.temperature.effect.TemperatureEffectLoader;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Thermoo
implements ModInitializer {
    public static final String MODID = "thermoo";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"thermoo");
    @Nullable
    private static ThermooConfig config = null;

    public void onInitialize() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)Thermoo.id("heating_mode"), HeatingModeArgumentType.class, (class_2314)class_2319.method_41999(HeatingModeArgumentType::heatingMode));
        ArgumentTypeRegistry.registerArgumentType((class_2960)Thermoo.id("temperature_unit"), TemperatureUnitArgumentType.class, (class_2314)class_2319.method_41999(TemperatureUnitArgumentType::temperatureUnit));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(TemperatureCommand.COMMAND_BUILDER.get());
            dispatcher.register(EnvironmentCommand.COMMAND_BUILDER.get());
            dispatcher.register(SoakingCommand.COMMAND_BUILDER.get());
        });
        DynamicRegistries.register(ThermooRegistryKeys.ENVIRONMENT, EnvironmentDefinition.CODEC);
        DynamicRegistries.register(ThermooRegistryKeys.ENVIRONMENT_PROVIDER, EnvironmentProvider.ELEMENT_CODEC);
        ThermooCommonRegisters.registerTemperatureEffects();
        ThermooCommonRegisters.registerEnvironmentProviderTypes();
        ThermooCommonRegisters.registerLootConditionTypes();
        ResourceManagerHelper serverManager = ResourceManagerHelper.get((class_3264)class_3264.field_14190);
        serverManager.registerReloadListener(TemperatureEffectLoader.ID, TemperatureEffectLoader::new);
        EnvironmentLookupImpl.initialize();
        LOGGER.info("Thermoo initialized");
    }

    @Contract(value="_->new")
    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    public static ThermooConfig getConfig() {
        if (config == null) {
            config = ThermooConfig.create();
        }
        return config;
    }
}

